/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.auth.DigestScheme;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AuthPolicy {
    private static final HashMap SCHEMES = new HashMap();
    private static final ArrayList SCHEME_LIST = new ArrayList();
    public static final String AUTH_SCHEME_PRIORITY = "http.auth.scheme-priority";
    public static final String NTLM = "NTLM";
    public static final String DIGEST = "Digest";
    public static final String BASIC = "Basic";
    protected static final Log LOG;

    static {
        AuthPolicy.registerAuthScheme(NTLM, NTLMScheme.class);
        AuthPolicy.registerAuthScheme(DIGEST, DigestScheme.class);
        AuthPolicy.registerAuthScheme(BASIC, BasicScheme.class);
        LOG = LogFactory.getLog(AuthPolicy.class);
    }

    public static synchronized void registerAuthScheme(String string, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Authentication scheme class may not be null");
        }
        SCHEMES.put(string.toLowerCase(), clazz);
        SCHEME_LIST.add(string.toLowerCase());
    }

    public static synchronized void unregisterAuthScheme(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SCHEMES.remove(string.toLowerCase());
        SCHEME_LIST.remove(string.toLowerCase());
    }

    public static synchronized AuthScheme getAuthScheme(String string) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        Class clazz = (Class)SCHEMES.get(string.toLowerCase());
        if (clazz != null) {
            try {
                return (AuthScheme)clazz.newInstance();
            }
            catch (Exception exception) {
                LOG.error("Error initializing authentication scheme: " + string, exception);
                throw new IllegalStateException(String.valueOf(string) + " authentication scheme implemented by " + clazz.getName() + " could not be initialized");
            }
        }
        throw new IllegalStateException("Unsupported authentication scheme " + string);
    }

    public static synchronized List getDefaultAuthPrefs() {
        return (List)SCHEME_LIST.clone();
    }
}

