/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.util.ParameterParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeaderElement
extends NameValuePair {
    private static final Log LOG = LogFactory.getLog(HeaderElement.class);
    private NameValuePair[] parameters = null;

    public HeaderElement() {
        this(null, null, null);
    }

    public HeaderElement(String string, String string2) {
        this(string, string2, null);
    }

    public HeaderElement(String string, String string2, NameValuePair[] nameValuePairArray) {
        super(string, string2);
        this.parameters = nameValuePairArray;
    }

    public HeaderElement(char[] cArray, int n, int n2) {
        this();
        if (cArray == null) {
            return;
        }
        ParameterParser parameterParser = new ParameterParser();
        List list = parameterParser.parse(cArray, n, n2, ';');
        if (list.size() > 0) {
            NameValuePair nameValuePair = (NameValuePair)list.remove(0);
            this.setName(nameValuePair.getName());
            this.setValue(nameValuePair.getValue());
            if (list.size() > 0) {
                this.parameters = list.toArray(new NameValuePair[list.size()]);
            }
        }
    }

    public HeaderElement(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public NameValuePair[] getParameters() {
        return this.parameters;
    }

    public static final HeaderElement[] parseElements(char[] cArray) {
        LOG.trace("enter HeaderElement.parseElements(char[])");
        if (cArray == null) {
            return new HeaderElement[0];
        }
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length;
        boolean bl = false;
        while (n < n3) {
            char c = cArray[n];
            if (c == '\"') {
                bl = !bl;
            }
            NameValuePair nameValuePair = null;
            if (!bl && c == ',') {
                nameValuePair = new HeaderElement(cArray, n2, n);
                n2 = n + 1;
            } else if (n == n3 - 1) {
                nameValuePair = new HeaderElement(cArray, n2, n3);
            }
            if (nameValuePair != null && nameValuePair.getName() != null) {
                arrayList.add(nameValuePair);
            }
            ++n;
        }
        return arrayList.toArray(new HeaderElement[arrayList.size()]);
    }

    public static final HeaderElement[] parseElements(String string) {
        LOG.trace("enter HeaderElement.parseElements(String)");
        if (string == null) {
            return new HeaderElement[0];
        }
        return HeaderElement.parseElements(string.toCharArray());
    }

    public static final HeaderElement[] parse(String string) throws HttpException {
        LOG.trace("enter HeaderElement.parse(String)");
        if (string == null) {
            return new HeaderElement[0];
        }
        return HeaderElement.parseElements(string.toCharArray());
    }

    public NameValuePair getParameterByName(String string) {
        LOG.trace("enter HeaderElement.getParameterByName(String)");
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        NameValuePair nameValuePair = null;
        NameValuePair[] nameValuePairArray = this.getParameters();
        if (nameValuePairArray != null) {
            int n = 0;
            while (n < nameValuePairArray.length) {
                NameValuePair nameValuePair2 = nameValuePairArray[n];
                if (nameValuePair2.getName().equalsIgnoreCase(string)) {
                    nameValuePair = nameValuePair2;
                    break;
                }
                ++n;
            }
        }
        return nameValuePair;
    }
}

