/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.NoHttpResponseException;

public class DefaultHttpMethodRetryHandler
implements HttpMethodRetryHandler {
    private static Class SSL_HANDSHAKE_EXCEPTION = null;
    private int retryCount;
    private boolean requestSentRetryEnabled;

    static {
        try {
            SSL_HANDSHAKE_EXCEPTION = Class.forName("javax.net.ssl.SSLHandshakeException");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public DefaultHttpMethodRetryHandler(int n, boolean bl) {
        this.retryCount = n;
        this.requestSentRetryEnabled = bl;
    }

    public DefaultHttpMethodRetryHandler() {
        this(3, false);
    }

    @Override
    public boolean retryMethod(HttpMethod httpMethod, IOException iOException, int n) {
        if (httpMethod == null) {
            throw new IllegalArgumentException("HTTP method may not be null");
        }
        if (iOException == null) {
            throw new IllegalArgumentException("Exception parameter may not be null");
        }
        if (httpMethod instanceof HttpMethodBase && ((HttpMethodBase)httpMethod).isAborted()) {
            return false;
        }
        if (n > this.retryCount) {
            return false;
        }
        if (iOException instanceof NoHttpResponseException) {
            return true;
        }
        if (iOException instanceof InterruptedIOException) {
            return false;
        }
        if (iOException instanceof UnknownHostException) {
            return false;
        }
        if (iOException instanceof NoRouteToHostException) {
            return false;
        }
        if (SSL_HANDSHAKE_EXCEPTION != null && SSL_HANDSHAKE_EXCEPTION.isInstance(iOException)) {
            return false;
        }
        return !httpMethod.isRequestSent() || this.requestSentRetryEnabled;
    }

    public boolean isRequestSentRetryEnabled() {
        return this.requestSentRetryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

