/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.util.LangUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cookie
extends NameValuePair
implements Serializable,
Comparator {
    private String cookieComment;
    private String cookieDomain;
    private Date cookieExpiryDate;
    private String cookiePath;
    private boolean isSecure;
    private boolean hasPathAttribute = false;
    private boolean hasDomainAttribute = false;
    private int cookieVersion = 0;
    private static final Log LOG = LogFactory.getLog(Cookie.class);

    public Cookie() {
        this(null, "noname", null, null, null, false);
    }

    public Cookie(String string, String string2, String string3) {
        this(string, string2, string3, null, null, false);
    }

    public Cookie(String string, String string2, String string3, String string4, Date date, boolean bl) {
        super(string2, string3);
        LOG.trace("enter Cookie(String, String, String, String, Date, boolean)");
        if (string2 == null) {
            throw new IllegalArgumentException("Cookie name may not be null");
        }
        if (string2.trim().equals("")) {
            throw new IllegalArgumentException("Cookie name may not be blank");
        }
        this.setPath(string4);
        this.setDomain(string);
        this.setExpiryDate(date);
        this.setSecure(bl);
    }

    public Cookie(String string, String string2, String string3, String string4, int n, boolean bl) {
        this(string, string2, string3, string4, null, bl);
        if (n < -1) {
            throw new IllegalArgumentException("Invalid max age:  " + Integer.toString(n));
        }
        if (n >= 0) {
            this.setExpiryDate(new Date(System.currentTimeMillis() + (long)n * 1000L));
        }
    }

    public String getComment() {
        return this.cookieComment;
    }

    public void setComment(String string) {
        this.cookieComment = string;
    }

    public Date getExpiryDate() {
        return this.cookieExpiryDate;
    }

    public void setExpiryDate(Date date) {
        this.cookieExpiryDate = date;
    }

    public boolean isPersistent() {
        return this.cookieExpiryDate != null;
    }

    public String getDomain() {
        return this.cookieDomain;
    }

    public void setDomain(String string) {
        if (string != null) {
            int n = string.indexOf(":");
            if (n != -1) {
                string = string.substring(0, n);
            }
            this.cookieDomain = string.toLowerCase();
        }
    }

    public String getPath() {
        return this.cookiePath;
    }

    public void setPath(String string) {
        this.cookiePath = string;
    }

    public boolean getSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean bl) {
        this.isSecure = bl;
    }

    public int getVersion() {
        return this.cookieVersion;
    }

    public void setVersion(int n) {
        this.cookieVersion = n;
    }

    public boolean isExpired() {
        return this.cookieExpiryDate != null && this.cookieExpiryDate.getTime() <= System.currentTimeMillis();
    }

    public boolean isExpired(Date date) {
        return this.cookieExpiryDate != null && this.cookieExpiryDate.getTime() <= date.getTime();
    }

    public void setPathAttributeSpecified(boolean bl) {
        this.hasPathAttribute = bl;
    }

    public boolean isPathAttributeSpecified() {
        return this.hasPathAttribute;
    }

    public void setDomainAttributeSpecified(boolean bl) {
        this.hasDomainAttribute = bl;
    }

    public boolean isDomainAttributeSpecified() {
        return this.hasDomainAttribute;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.getName());
        n = LangUtils.hashCode(n, this.cookieDomain);
        n = LangUtils.hashCode(n, this.cookiePath);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Cookie) {
            Cookie cookie = (Cookie)object;
            return LangUtils.equals(this.getName(), cookie.getName()) && LangUtils.equals(this.cookieDomain, cookie.cookieDomain) && LangUtils.equals(this.cookiePath, cookie.cookiePath);
        }
        return false;
    }

    public String toExternalForm() {
        CookieSpec cookieSpec = null;
        cookieSpec = this.getVersion() > 0 ? CookiePolicy.getDefaultSpec() : CookiePolicy.getCookieSpec("netscape");
        return cookieSpec.formatCookie(this);
    }

    public int compare(Object object, Object object2) {
        LOG.trace("enter Cookie.compare(Object, Object)");
        if (!(object instanceof Cookie)) {
            throw new ClassCastException(object.getClass().getName());
        }
        if (!(object2 instanceof Cookie)) {
            throw new ClassCastException(object2.getClass().getName());
        }
        Cookie cookie = (Cookie)object;
        Cookie cookie2 = (Cookie)object2;
        if (cookie.getPath() == null && cookie2.getPath() == null) {
            return 0;
        }
        if (cookie.getPath() == null) {
            if (cookie2.getPath().equals("/")) {
                return 0;
            }
            return -1;
        }
        if (cookie2.getPath() == null) {
            if (cookie.getPath().equals("/")) {
                return 0;
            }
            return 1;
        }
        return cookie.getPath().compareTo(cookie2.getPath());
    }

    @Override
    public String toString() {
        return this.toExternalForm();
    }
}

