/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectMethod
extends HttpMethodBase {
    public static final String NAME = "CONNECT";
    private final HostConfiguration targethost;
    private static final Log LOG = LogFactory.getLog(ConnectMethod.class);

    public ConnectMethod() {
        this.targethost = null;
    }

    public ConnectMethod(HttpMethod httpMethod) {
        this.targethost = null;
    }

    public ConnectMethod(HostConfiguration hostConfiguration) {
        if (hostConfiguration == null) {
            throw new IllegalArgumentException("Target host may not be null");
        }
        this.targethost = hostConfiguration;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getPath() {
        if (this.targethost != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.targethost.getHost());
            int n = this.targethost.getPort();
            if (n == -1) {
                n = this.targethost.getProtocol().getDefaultPort();
            }
            stringBuffer.append(':');
            stringBuffer.append(n);
            return stringBuffer.toString();
        }
        return "/";
    }

    @Override
    public URI getURI() throws URIException {
        String string = this.getParams().getUriCharset();
        return new URI(this.getPath(), true, string);
    }

    @Override
    protected void addCookieRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
    }

    @Override
    protected void addRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter ConnectMethod.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(httpState, httpConnection);
        this.addHostRequestHeader(httpState, httpConnection);
        this.addProxyConnectionHeader(httpState, httpConnection);
    }

    @Override
    public int execute(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter ConnectMethod.execute(HttpState, HttpConnection)");
        int n = super.execute(httpState, httpConnection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CONNECT status code " + n);
        }
        return n;
    }

    @Override
    protected void writeRequestLine(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append(' ');
        if (this.targethost != null) {
            stringBuffer.append(this.getPath());
        } else {
            int n = httpConnection.getPort();
            if (n == -1) {
                n = httpConnection.getProtocol().getDefaultPort();
            }
            stringBuffer.append(httpConnection.getHost());
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.getEffectiveVersion());
        String string = stringBuffer.toString();
        httpConnection.printLine(string, this.getParams().getHttpElementCharset());
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output(string);
        }
    }

    @Override
    protected boolean shouldCloseConnection(HttpConnection httpConnection) {
        if (this.getStatusCode() == 200) {
            Header header = null;
            if (!httpConnection.isTransparent()) {
                header = this.getResponseHeader("proxy-connection");
            }
            if (header == null) {
                header = this.getResponseHeader("connection");
            }
            if (header != null && header.getValue().equalsIgnoreCase("close") && LOG.isWarnEnabled()) {
                LOG.warn("Invalid header encountered '" + header.toExternalForm() + "' in response " + this.getStatusLine().toString());
            }
            return false;
        }
        return super.shouldCloseConnection(httpConnection);
    }
}

