/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.util.EncodingUtil;

public class ChunkedOutputStream
extends OutputStream {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] ENDCHUNK = CRLF;
    private static final byte[] ZERO = new byte[]{48};
    private OutputStream stream = null;
    private byte[] cache;
    private int cachePosition = 0;
    private boolean wroteLastChunk = false;

    public ChunkedOutputStream(OutputStream outputStream, int n) throws IOException {
        this.cache = new byte[n];
        this.stream = outputStream;
    }

    public ChunkedOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 2048);
    }

    protected void flushCache() throws IOException {
        if (this.cachePosition > 0) {
            byte[] byArray = EncodingUtil.getAsciiBytes(String.valueOf(Integer.toHexString(this.cachePosition)) + "\r\n");
            this.stream.write(byArray, 0, byArray.length);
            this.stream.write(this.cache, 0, this.cachePosition);
            this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
            this.cachePosition = 0;
        }
    }

    protected void flushCacheWithAppend(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = EncodingUtil.getAsciiBytes(String.valueOf(Integer.toHexString(this.cachePosition + n2)) + "\r\n");
        this.stream.write(byArray2, 0, byArray2.length);
        this.stream.write(this.cache, 0, this.cachePosition);
        this.stream.write(byArray, n, n2);
        this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
        this.cachePosition = 0;
    }

    protected void writeClosingChunk() throws IOException {
        this.stream.write(ZERO, 0, ZERO.length);
        this.stream.write(CRLF, 0, CRLF.length);
        this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
    }

    public void finish() throws IOException {
        if (!this.wroteLastChunk) {
            this.flushCache();
            this.writeClosingChunk();
            this.wroteLastChunk = true;
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.cache[this.cachePosition] = (byte)n;
        ++this.cachePosition;
        if (this.cachePosition == this.cache.length) {
            this.flushCache();
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.cache.length - this.cachePosition) {
            this.flushCacheWithAppend(byArray, n, n2);
        } else {
            System.arraycopy(byArray, n, this.cache, this.cachePosition, n2);
            this.cachePosition += n2;
        }
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.finish();
        super.close();
    }
}

