/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util.script;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.Bindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JSUtil.class);
    private static final AtomicBoolean checkReflect = new AtomicBoolean();
    private static Class<?> classScriptObject;
    private static Method methodNashornIsArray;
    private static Method methodNashornValues;

    private static Method getMethod(Class clazz, String string) {
        if (clazz != null) {
            try {
                Method method = clazz.getMethod(string, new Class[0]);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Detected JS method: " + clazz + "." + string + "()");
                }
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOG.warn("No JS method: " + clazz + "." + string + "()");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] jsArrayToJavaArray(Object object) {
        if (object instanceof Bindings) {
            Class<?> clazz = object.getClass();
            if (clazz.getName().equals("jdk.nashorn.api.scripting.ScriptObjectMirror")) {
                Method method;
                Method method2;
                Class<?> clazz2;
                Object object2 = checkReflect;
                synchronized (object2) {
                    boolean bl;
                    boolean bl2 = bl = !checkReflect.getAndSet(true);
                    if (!bl && classScriptObject != null && !classScriptObject.isAssignableFrom(clazz)) {
                        LOG.warn(JSUtil.toStrWithClass("Object is different JS object: ", object));
                        bl = true;
                    }
                    if (bl) {
                        classScriptObject = clazz;
                        methodNashornIsArray = JSUtil.getMethod(clazz, "isArray");
                        methodNashornValues = JSUtil.getMethod(clazz, "values");
                    }
                    clazz2 = classScriptObject;
                    method2 = methodNashornIsArray;
                    method = methodNashornValues;
                }
                if (clazz2 != null && method2 != null && method != null) {
                    try {
                        object2 = method2.invoke(object, new Object[0]);
                        if (object2 != null && object2.equals(true)) {
                            Object object3 = method.invoke(object, new Object[0]);
                            return JSUtil.toArray(object3);
                        }
                        LOG.warn(JSUtil.toStrWithClass("Object is not an array: ", object));
                    }
                    catch (Exception exception) {
                        LOG.warn("Cannot convert array: " + object, (Throwable)exception);
                    }
                }
            } else {
                LOG.warn(JSUtil.toStrWithClass("Unexpected JS class: ", object));
            }
        } else {
            return JSUtil.toArray(object);
        }
        return null;
    }

    private static final String toStrWithClass(String string, Object object) {
        return String.valueOf(string) + object + (object != null ? " [" + object.getClass() + "]" : "");
    }

    private static final Object[] toArray(Object object) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return collection.toArray(new Object[collection.size()]);
        }
        LOG.warn(JSUtil.toStrWithClass("Array values not a collection: ", object));
        return null;
    }
}

