/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util.logging;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ToString {
    private static final int COLS_BYTE = 16;
    private static final int GAP = 2;
    private static final char[] SPACES = new char[48];
    private static final char[] TABS = new char[32];
    private final StringBuilder buf;
    private int indent = 0;

    static {
        Arrays.fill(TABS, '\t');
        Arrays.fill(SPACES, ' ');
    }

    private static final boolean checkAddNL(Collection collection) {
        return collection == null || collection.size() <= 0 || ToString.checkAddNL(collection.iterator().next());
    }

    private static final boolean checkAddNL(Object object) {
        return !(object instanceof Point) && !(object instanceof IToStringSimple);
    }

    private static final boolean checkAddNL(Object[] objectArray) {
        return objectArray == null || objectArray.length <= 0 || ToString.checkAddNL(objectArray[0]);
    }

    private static final String toStringDataType(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "Byte";
                break;
            }
            case 1: {
                string = "UnsignedShort";
                break;
            }
            case 2: {
                string = "Short";
                break;
            }
            case 3: {
                string = "Int";
                break;
            }
            case 4: {
                string = "Float";
                break;
            }
            case 5: {
                string = "Double";
                break;
            }
            case 32: {
                string = "Undefined";
                break;
            }
            default: {
                string = "Unknown [" + n + "]";
            }
        }
        return string;
    }

    public ToString() {
        this.buf = new StringBuilder();
    }

    public ToString(int n) {
        this(n, 0);
    }

    public ToString(int n, int n2) {
        this.buf = n > 0 ? new StringBuilder(n) : new StringBuilder();
        int n3 = this.indent = n2 >= 0 ? n2 : 0;
        if (this.indent > 0) {
            this.buf.append(TABS, 0, Math.min(this.indent, TABS.length));
        }
    }

    private void addDescription(String string, boolean bl) {
        this.addIndent(bl);
        if (string != null) {
            this.buf.append(string).append('=');
        }
    }

    private ToString addIndent(boolean bl) {
        if (bl) {
            this.buf.append('\n');
            this.buf.append(TABS, 0, Math.min(this.indent, TABS.length));
        }
        return this;
    }

    public ToString append(int n) {
        this.buf.append(n);
        return this;
    }

    public ToString append(String string) {
        this.buf.append(string);
        return this;
    }

    public ToString append(String string, Area area) {
        return this.append(string, area, false);
    }

    public ToString append(String string, boolean bl) {
        return this.append(string, bl, false);
    }

    public ToString append(String string, boolean bl, boolean bl2) {
        this.addDescription(string, bl2);
        this.buf.append(bl);
        return this;
    }

    public ToString append(String string, byte[] byArray) {
        return this.append(string, byArray, 0, byArray != null ? byArray.length : 0, false);
    }

    public ToString append(String string, byte[] byArray, int n, int n2, boolean bl) {
        this.addDescription(string, bl);
        if (byArray != null) {
            if (byArray.length == 0 || n2 == 0) {
                this.buf.append("<empty>");
            } else if (n < 0 || n2 < 0 || n > byArray.length) {
                this.buf.append("Invalid offset/length").append(n).append('/').append(n2);
            } else {
                if (n + n2 > byArray.length) {
                    n2 = byArray.length - n;
                }
                StringBuilder stringBuilder = new StringBuilder(48);
                StringBuilder stringBuilder2 = new StringBuilder(16);
                int n3 = n + n2;
                int n4 = n;
                while (n4 < n3) {
                    byte by = byArray[n4];
                    String string2 = String.format("%1$02X", by);
                    stringBuilder.append(string2);
                    stringBuilder.append(' ');
                    stringBuilder2.append(by >= 32 && by <= 126 ? (char)by : (char)'.');
                    boolean bl2 = n4 >= n3 - 1;
                    int n5 = (n4 - n + 1) % 16;
                    if (n5 == 0 || bl2) {
                        this.addIndent(true);
                        this.buf.append((CharSequence)stringBuilder);
                        this.buf.append(SPACES, 0, n5 == 0 ? 1 : (16 - n5) * 3 + 2 - 1);
                        this.buf.append((CharSequence)stringBuilder2);
                        if (!bl2) {
                            stringBuilder.setLength(0);
                            stringBuilder2.setLength(0);
                        }
                    }
                    ++n4;
                }
            }
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, Collection<?> collection) {
        return this.append(string, collection, false, ToString.checkAddNL(collection));
    }

    public ToString append(String string, Collection<?> collection, boolean bl, boolean bl2) {
        this.addDescription(string, bl);
        if (collection == null) {
            this.buf.append("[null]");
        } else if (collection.size() <= 0) {
            this.buf.append("[empty]");
        } else {
            Iterator<?> iterator = collection.iterator();
            this.more();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                this.appendInt(null, obj, bl2);
                if (bl2 || !iterator.hasNext()) continue;
                this.buf.append(',');
            }
            this.less();
        }
        return this;
    }

    public ToString append(String string, ColorSpace colorSpace) {
        return this.append(string, colorSpace, false);
    }

    public ToString append(String string, ColorSpace colorSpace, boolean bl) {
        this.addDescription(string, bl);
        if (colorSpace != null) {
            String string2;
            this.buf.append(colorSpace.getClass().getSimpleName());
            switch (colorSpace.getType()) {
                case 5: {
                    string2 = "RGB";
                    break;
                }
                case 0: {
                    string2 = "XYZ";
                    break;
                }
                case 1: {
                    string2 = "Lab";
                    break;
                }
                case 2: {
                    string2 = "Luv";
                    break;
                }
                case 3: {
                    string2 = "YCbCr";
                    break;
                }
                case 4: {
                    string2 = "Yxy";
                    break;
                }
                case 6: {
                    string2 = "Gray";
                    break;
                }
                case 7: {
                    string2 = "HSV";
                    break;
                }
                case 8: {
                    string2 = "HLS";
                    break;
                }
                case 9: {
                    string2 = "CMYK";
                    break;
                }
                case 11: {
                    string2 = "CMY";
                    break;
                }
                default: {
                    string2 = "[" + colorSpace.getType() + "]";
                }
            }
            this.buf.append(", Type=").append(string2);
            this.buf.append(", isCS_sRGB=").append(colorSpace.isCS_sRGB());
            int n = colorSpace.getNumComponents();
            this.buf.append(", Components:");
            int n2 = 0;
            while (n2 < n) {
                this.buf.append(" ").append(n2).append("=");
                this.buf.append(colorSpace.getMinValue(n2)).append('-');
                this.buf.append(colorSpace.getMaxValue(n2)).append(',');
                ++n2;
            }
            if (colorSpace instanceof ICC_ColorSpace) {
                ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)colorSpace;
                this.append(", Profile=", iCC_ColorSpace.getProfile(), bl);
            }
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, DataBuffer dataBuffer) {
        return this.append(string, dataBuffer, false);
    }

    public ToString append(String string, DataBuffer dataBuffer, boolean bl) {
        this.addDescription(string, bl);
        if (dataBuffer != null) {
            this.buf.append(dataBuffer.getClass().getSimpleName());
            this.buf.append(", Type=").append(ToString.toStringDataType(dataBuffer.getDataType()));
            this.buf.append(", NumBanks=").append(dataBuffer.getNumBanks());
            this.buf.append(", Size=").append(dataBuffer.getSize());
            this.buf.append(", Offset=").append(dataBuffer.getOffset());
            this.buf.append(", Offsets=").append(Arrays.toString(dataBuffer.getOffsets()));
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, ICC_Profile iCC_Profile) {
        return this.append(string, iCC_Profile, false);
    }

    public ToString append(String string, ICC_Profile iCC_Profile, boolean bl) {
        this.addDescription(string, bl);
        if (iCC_Profile != null) {
            this.buf.append(iCC_Profile.getClass().getSimpleName());
            this.buf.append(", Type=").append(iCC_Profile.getColorSpaceType());
            this.buf.append(", PCSType=").append(iCC_Profile.getPCSType());
            this.buf.append(", Class=").append(iCC_Profile.getProfileClass());
            this.buf.append(", Version=").append(iCC_Profile.getMajorVersion());
            this.buf.append(".").append(iCC_Profile.getMinorVersion());
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, IIOMetadata iIOMetadata) {
        this.addDescription(string, false);
        if (iIOMetadata != null) {
            String[] stringArray = iIOMetadata.getMetadataFormatNames();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                this.addIndent(true);
                this.buf.append("Format [").append(n).append('/').append(stringArray.length);
                this.buf.append("]=").append(string2);
                Node node = iIOMetadata.getAsTree(string2);
                this.more();
                this.appendNode(node);
                this.less();
                ++n;
            }
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, int n) {
        return this.append(string, n, false);
    }

    public ToString append(String string, int n, boolean bl) {
        this.addDescription(string, bl);
        this.buf.append(n);
        return this;
    }

    public ToString append(String string, Map map) {
        return this.append(string, map, false, true);
    }

    public ToString append(String string, Map map, boolean bl, boolean bl2) {
        this.addDescription(string, bl);
        if (map == null) {
            this.buf.append("[null]");
        } else if (map.size() <= 0) {
            this.buf.append("[empty]");
        } else {
            this.more();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.addDescription(String.valueOf(entry.getKey()), bl2);
                this.buf.append(entry.getValue());
                if (bl2 || !iterator.hasNext()) continue;
                this.buf.append(',');
            }
            this.less();
        }
        return this;
    }

    public ToString append(String string, Node node) {
        this.addDescription(string, false);
        if (node != null) {
            this.appendNode(node);
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, Object object) {
        return this.append(string, object, false);
    }

    public ToString append(String string, Object object, boolean bl) {
        this.addDescription(string, bl);
        this.buf.append(object);
        return this;
    }

    public ToString append(String string, Object[] objectArray) {
        return this.append(string, objectArray, false, ToString.checkAddNL(objectArray));
    }

    public ToString append(String string, Object[] objectArray, boolean bl, boolean bl2) {
        return this.append(string, objectArray, bl, bl2 ? "," : "\n");
    }

    public ToString append(String string, Object[] objectArray, boolean bl, String string2) {
        this.addDescription(string, bl);
        if (objectArray == null) {
            this.buf.append("[null]");
        } else if (objectArray.length <= 0) {
            this.buf.append("[empty]");
        } else {
            this.more();
            boolean bl2 = string2 != null && string2.equals("\n");
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                this.appendInt(null, object, bl2);
                if (!bl2 && string2 != null && n < objectArray.length - 1) {
                    this.buf.append(string2);
                }
                ++n;
            }
            this.less();
        }
        return this;
    }

    public ToString append(String string, Point point) {
        return this.append(string, point, false);
    }

    public ToString append(String string, Point point, boolean bl) {
        this.addDescription(string, bl);
        if (point != null) {
            this.buf.append(point.x).append('x').append(point.y);
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, Raster raster) {
        return this.append(string, raster, false);
    }

    public ToString append(String string, Raster raster, boolean bl) {
        this.addDescription(string, bl);
        if (raster != null) {
            int n = Math.min(raster.getWidth(), 100);
            int n2 = Math.min(raster.getHeight(), 100);
            int n3 = raster.getNumBands();
            int[] nArray = null;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n) {
                    nArray = raster.getPixel(n5, n4, nArray);
                    this.buf.append("0x");
                    int n6 = 0;
                    while (n6 < n3) {
                        this.buf.append(String.format("%1$02X", nArray[n6]));
                        ++n6;
                    }
                    this.buf.append(' ');
                    ++n5;
                }
                if (n4 < n2 - 1) {
                    this.addIndent(true);
                }
                ++n4;
            }
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, Rectangle rectangle) {
        return this.append(string, rectangle, false);
    }

    public ToString append(String string, Rectangle rectangle, boolean bl) {
        this.addDescription(string, bl);
        if (rectangle != null) {
            this.buf.append(rectangle.x).append('x').append(rectangle.y);
            this.buf.append('/').append(rectangle.width).append('x').append(rectangle.height);
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, RenderedImage renderedImage) {
        return this.append(string, renderedImage, false, false);
    }

    public ToString append(String string, RenderedImage renderedImage, boolean bl, boolean bl2) {
        this.appendID(string, renderedImage, bl);
        if (renderedImage != null) {
            if (bl2) {
                this.append(null, renderedImage.getData());
            } else {
                this.buf.append(' ').append(renderedImage);
            }
        }
        return this;
    }

    public ToString append(String string, SampleModel sampleModel) {
        return this.append(string, sampleModel, false);
    }

    public ToString append(String string, SampleModel sampleModel, boolean bl) {
        this.addDescription(string, bl);
        if (sampleModel != null) {
            this.buf.append(sampleModel.getClass().getSimpleName());
            this.buf.append(", Type=").append(ToString.toStringDataType(sampleModel.getDataType()));
            this.buf.append(", Size=").append(sampleModel.getWidth());
            this.buf.append('x').append(sampleModel.getHeight());
            this.buf.append(", SampleSize=").append(Arrays.toString(sampleModel.getSampleSize()));
            this.buf.append(", NumBands=").append(sampleModel.getNumBands());
            this.buf.append(", Elements=").append(sampleModel.getNumDataElements());
        } else {
            this.buf.append("null");
        }
        return this;
    }

    public ToString append(String string, Shape shape, boolean bl) {
        this.addDescription(string, bl);
        if (shape != null) {
            if (shape instanceof Area && ((Area)shape).isRectangular()) {
                this.append(null, shape.getBounds());
            } else {
                PathIterator pathIterator = shape.getPathIterator(null);
                float[] fArray = new float[]{0.0f, 0.0f};
                this.buf.append(" [");
                while (!pathIterator.isDone()) {
                    int n = pathIterator.currentSegment(fArray);
                    switch (n) {
                        case 1: {
                            break;
                        }
                        case 0: {
                            this.buf.append("->");
                            break;
                        }
                        case 4: {
                            this.buf.append("|");
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.buf.append("?");
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    this.buf.append(fArray[0]).append('x').append(fArray[1]);
                    pathIterator.next();
                    if (pathIterator.isDone()) continue;
                    this.buf.append(", ");
                }
                this.buf.append(']');
            }
        } else {
            this.buf.append("null");
        }
        return this;
    }

    private void appendAttributes(NamedNodeMap namedNodeMap, boolean bl) {
        int n = namedNodeMap.getLength();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                this.addIndent(n2 != 0 || bl);
                Node node = namedNodeMap.item(n2);
                this.buf.append(node.getNodeName());
                this.buf.append("=");
                this.buf.append(node.getNodeValue());
                ++n2;
            }
        }
    }

    public ToString appendID(String string, Object object) {
        return this.appendID(string, object, false);
    }

    public ToString appendID(String string, Object object, boolean bl) {
        this.addDescription(string, bl);
        if (object != null) {
            this.buf.append('@').append(Integer.toHexString(System.identityHashCode(object)));
        } else {
            this.buf.append("null");
        }
        return this;
    }

    private ToString appendInt(String string, Object object, boolean bl) {
        if (object instanceof Point) {
            this.append(string, (Point)object, bl);
        } else if (object instanceof Rectangle) {
            this.append(string, (Rectangle)object, bl);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            this.append(string, collection, bl, ToString.checkAddNL(collection));
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            this.append(string, objectArray, bl, ToString.checkAddNL(objectArray));
        } else {
            this.addDescription(string, bl);
            this.buf.append(object);
        }
        return this;
    }

    private void appendNode(Node node) {
        Object object;
        this.addIndent(true);
        if (node.getNodeType() == 3) {
            this.buf.append("\"").append(((Text)node).getData()).append("\"");
        } else {
            this.buf.append(node.getNodeName());
        }
        this.more();
        if (node.hasAttributes()) {
            object = node.getAttributes();
            this.appendAttributes((NamedNodeMap)object, true);
        }
        object = node.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Node node2 = object.item(n);
            this.appendNode(node2);
            ++n;
        }
        this.less();
    }

    public ToString less() {
        if (this.indent > 0) {
            --this.indent;
        }
        return this;
    }

    public ToString more() {
        ++this.indent;
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public static interface IToStringSimple {
    }
}

