/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class SimpleFormatter
extends Formatter {
    private static final String FORMAT = "{0,date,yyyy.MM.dd} {0,time,HH:mm:ss:SSS} ";
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String SPACES;
    private final EnumSet<Add> addMask;
    private final Object[] args = new Object[1];
    private final Date date = new Date();
    private final MessageFormat formatter = new MessageFormat("{0,date,yyyy.MM.dd} {0,time,HH:mm:ss:SSS} ");
    private final int logNameLimit;

    static {
        char[] cArray = new char[64];
        Arrays.fill(cArray, ' ');
        SPACES = new String(cArray);
    }

    private static final String levelToStr(Level level) {
        if (level.intValue() <= Level.FINE.intValue()) {
            return "DBG ";
        }
        if (level.intValue() <= Level.INFO.intValue()) {
            return "INFO";
        }
        if (level.intValue() <= Level.WARNING.intValue()) {
            return "WARN";
        }
        if (level.intValue() <= Level.SEVERE.intValue()) {
            return "ERR ";
        }
        return "OFF ";
    }

    public SimpleFormatter() {
        this(EnumSet.of(Add.TIME, Add.LOGGER_NAME, Add.THREAD_ID), -1);
    }

    public SimpleFormatter(EnumSet<Add> enumSet, int n) throws IllegalArgumentException {
        if (enumSet == null || enumSet.isEmpty()) {
            throw new IllegalArgumentException("Invalid mask " + enumSet);
        }
        this.addMask = enumSet;
        this.logNameLimit = n;
    }

    @Override
    public synchronized String format(LogRecord logRecord) {
        CharSequence charSequence;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.addMask.contains((Object)Add.TIME)) {
            this.date.setTime(logRecord.getMillis());
            this.args[0] = this.date;
            charSequence = new StringBuffer();
            this.formatter.format(this.args, (StringBuffer)charSequence, (FieldPosition)null);
            stringBuilder.append((StringBuffer)charSequence);
        }
        stringBuilder.append(SimpleFormatter.levelToStr(logRecord.getLevel()));
        if (this.addMask.contains((Object)Add.LOGGER_NAME) || this.addMask.contains((Object)Add.LOGGER_SHORT_NAME)) {
            int n;
            stringBuilder.append(' ');
            charSequence = logRecord.getLoggerName();
            int n2 = ((String)charSequence).length();
            if (this.addMask.contains((Object)Add.LOGGER_SHORT_NAME) && (n = ((String)charSequence).lastIndexOf(46)) >= 0 && n < n2 - 1) {
                charSequence = ((String)charSequence).substring(n + 1, n2);
                n2 = ((String)charSequence).length();
            }
            if (this.logNameLimit > 0) {
                charSequence = n2 > this.logNameLimit ? ((String)charSequence).substring(n2 - this.logNameLimit, n2) : String.valueOf(charSequence) + SPACES.substring(0, Math.min(SPACES.length(), this.logNameLimit - n2));
            }
            stringBuilder.append((String)charSequence);
        }
        if (this.addMask.contains((Object)Add.CLASS_NAME) && logRecord.getSourceClassName() != null) {
            stringBuilder.append(' ');
            stringBuilder.append(logRecord.getSourceClassName());
        }
        if (this.addMask.contains((Object)Add.METHOD_NAME) && logRecord.getSourceMethodName() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(logRecord.getSourceMethodName());
        }
        if (this.addMask.contains((Object)Add.THREAD_ID)) {
            stringBuilder.append(" [").append(logRecord.getThreadID()).append("]");
        }
        stringBuilder.append(": ");
        charSequence = this.formatMessage(logRecord);
        stringBuilder.append((String)charSequence);
        stringBuilder.append(lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuilder.append(stringWriter.toString());
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }

    public static enum Add {
        ALL,
        CLASS_NAME,
        LOGGER_NAME,
        LOGGER_SHORT_NAME,
        METHOD_NAME,
        THREAD_ID,
        TIME;

    }
}

