/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util.logging;

import com.deltopia.util.logging.ConsoleHandler;
import com.deltopia.util.logging.FileHandler;
import com.deltopia.util.logging.HookLogListener;
import com.deltopia.util.logging.SimpleFormatter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogUtil {
    private static final EnumSet<SimpleFormatter.Add> ADD_MASK = EnumSet.of(SimpleFormatter.Add.TIME, SimpleFormatter.Add.LOGGER_SHORT_NAME, SimpleFormatter.Add.THREAD_ID);
    private static final File CONFIG_DIR;
    private static final String CONFIG_FILE_NAME = "dw_log.properties";
    private static final String DEF_CONFIG_FILE_CONTENT = "############################################################\n# Logging Configuration File\n#\n############################################################\n\n############################################################\n# Global properties\n############################################################\n\n# Default global logging level.\n# This specifies which kinds of events are logged across\n# all loggers. For any given facility this global level\n# can be overriden by a facility specific level\n#.level=INFO\n.level=WARNING\n\n############################################################\n# Handler specific properties.\n# Describes specific configuration info for Handlers.\n############################################################\ncom.deltopia.util.logging.FileHandler.level=INFO\ncom.deltopia.util.logging.ConsoleHandler.level=SEVERE\n\n\n############################################################\n# Facility specific properties.\n# Provides extra control for each logger.\n############################################################\n\n# For example, set the com.xyz.foo logger to only log SEVERE\n# messages:\n#com.xyz.foo.level=SEVERE\n";
    public static final String ECLIPSE_LOG_FILE_SEGMENT = ".metadata/.log";
    private static boolean initialized;
    private static final String LEVEL_SUFFIX = ".level";
    private static final File LOG_DIR;
    private static final String LOG_FILE_NAME = "dw.log";
    private static final int MAX_FILES = 2;
    private static final String NAME_LOGGER_SYSTEM = "deltawalker.eclipse";
    private static final boolean TRACE = false;

    static {
        initialized = false;
        File file = null;
        File file2 = null;
        if (Platform.isRunning()) {
            try {
                File file3;
                file = file3 = new File(Platform.getInstanceLocation().getURL().getFile());
                file2 = file3;
                if (!(file3.isDirectory() || file3.mkdirs() || file3.isDirectory())) {
                    System.err.println("Cannot create application config folder " + file3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (file == null) {
            file = new File(System.getProperty("user.dir"));
            System.err.println("Cannot get application location. Use current: " + file);
        }
        if (file2 == null) {
            file2 = file;
        }
        LOG_DIR = file;
        CONFIG_DIR = file2;
    }

    static final void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static File configFile() {
        return new File(CONFIG_DIR, CONFIG_FILE_NAME);
    }

    private static final void createDefaultConfigFile(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                    bufferedWriter.write(DEF_CONFIG_FILE_CONTENT);
                    bufferedWriter.flush();
                }
                catch (Exception exception) {
                    System.err.println("Write to file failed " + file + ": " + exception);
                    LogUtil.closeSilently(fileOutputStream);
                }
            }
            finally {
                LogUtil.closeSilently(fileOutputStream);
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot write to file " + file + ": " + exception);
        }
    }

    private static final Handler[] createHandlers(Properties properties) {
        LinkedList<StreamHandler> linkedList = new LinkedList<StreamHandler>();
        SimpleFormatter simpleFormatter = new SimpleFormatter(ADD_MASK, 20);
        linkedList.add(new ConsoleHandler());
        try {
            int n = LogUtil.getProperty(properties, "com.deltopia.util.logging.FileHandler.limit", 0x300000);
            File file = new File(LOG_DIR, LOG_FILE_NAME);
            linkedList.add(new FileHandler(file, n, 2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (Handler handler : linkedList) {
            handler.setFormatter(simpleFormatter);
        }
        return linkedList.toArray(new Handler[2]);
    }

    private static void fixAllLoggers(Properties properties) {
        LogManager logManager = LogManager.getLogManager();
        Set<String> set = LogUtil.getAllLoggers(logManager, false);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            java.util.logging.Logger logger;
            Level level;
            int n;
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.endsWith(LEVEL_SUFFIX) || (string = string2.substring(0, n = string2.length() - LEVEL_SUFFIX.length())).length() <= 0 || string.endsWith("Handler") || (level = LogUtil.getLevelProperty(properties, string, null)) == null || (logger = logManager.getLogger(string)) != null) continue;
            LogUtil.fixLoggers(string, set);
        }
    }

    private static final void fixLogger(String string, String string2) {
        String string3 = string;
        while (string3.length() > 0) {
            int n = string3.lastIndexOf(".");
            if (n <= 0 || n >= string3.length() - 1) break;
            string3 = string3.substring(0, n);
            java.util.logging.Logger.getLogger(string3);
            if (string3.equals(string2)) break;
        }
    }

    private static final void fixLoggers(String string, Set<String> set) {
        String string2 = String.valueOf(string) + ".";
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            if (!string3.startsWith(string2)) continue;
            LogUtil.fixLogger(string3, string);
            iterator.remove();
        }
    }

    private static Set<String> getAllLoggers(LogManager logManager, boolean bl) {
        Enumeration<String> enumeration = logManager.getLoggerNames();
        HashSet<String> hashSet = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!bl && (string.equals("global") || string.length() <= 0)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static Level getLevelProperty(Properties properties, String string, Level level) {
        return LogUtil.getProperty(properties, String.valueOf(string) + LEVEL_SUFFIX, level);
    }

    private static <T> T getProperty(Properties properties, String string, T t) {
        String string2 = properties == null ? LogManager.getLogManager().getProperty(string) : properties.getProperty(string);
        if (string2 == null) {
            return t;
        }
        try {
            Serializable serializable;
            if (t instanceof Level) {
                serializable = Level.parse(string2.trim());
            } else if (t instanceof Integer) {
                serializable = Integer.valueOf(Integer.parseInt(string2.trim()));
            } else if (t instanceof Long) {
                serializable = Long.valueOf(Long.parseLong(string2.trim()));
            } else {
                throw new IllegalStateException("Unexpected class " + t);
            }
            return (T)serializable;
        }
        catch (Exception exception) {
            System.err.println("Cannot parse '" + string + "'=" + string2 + ": " + exception);
            return t;
        }
    }

    public static final File getLogDirectory() {
        return LOG_DIR;
    }

    public static final Set<File> getLogFiles() {
        File file;
        HashSet<File> hashSet = new HashSet<File>(2);
        File[] fileArray = LOG_DIR.listFiles(LogFilenameFilter.INSTANCE);
        if (fileArray != null && fileArray.length > 0) {
            Collections.addAll(hashSet, fileArray);
        }
        if ((file = new File(LOG_DIR, ECLIPSE_LOG_FILE_SEGMENT)).exists()) {
            hashSet.add(file);
        }
        return hashSet;
    }

    public static final synchronized boolean loadConfiguration() {
        boolean bl = LogUtil.loadProperties(null);
        if (bl) {
            LogUtil.setupHandlers(null, bl);
            Properties properties = new Properties();
            LogUtil.loadProperties(properties);
            long l = 0L;
            LogUtil.fixAllLoggers(properties);
        }
        return bl;
    }

    private static final boolean loadProperties(Properties properties) {
        File file = LogUtil.configFile();
        if (!file.exists()) {
            if (!LOG_DIR.exists() && !LOG_DIR.mkdir()) {
                System.err.println("Couldn't create " + LOG_DIR);
            }
            LogUtil.createDefaultConfigFile(file);
        }
        if (file.exists()) {
            FileInputStream fileInputStream;
            block9: {
                fileInputStream = new FileInputStream(file);
                try {
                    if (properties == null) {
                        LogManager.getLogManager().readConfiguration(fileInputStream);
                        break block9;
                    }
                    properties.clear();
                    properties.load(fileInputStream);
                }
                catch (Throwable throwable) {
                    try {
                        LogUtil.closeSilently(fileInputStream);
                        throw throwable;
                    }
                    catch (Exception exception) {
                        System.err.println(exception.toString());
                    }
                }
            }
            LogUtil.closeSilently(fileInputStream);
            return true;
        }
        return false;
    }

    private static final void setupHandlers(Properties properties, boolean bl) {
        boolean bl2 = properties == null;
        try {
            Handler[] handlerArray;
            Object object;
            int n;
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger("");
            Handler[] handlerArray2 = logger.getHandlers();
            if (bl2 || handlerArray2 == null || handlerArray2.length <= 0) {
                try {
                    if (handlerArray2 != null && handlerArray2.length > 0) {
                        Handler[] handlerArray3 = handlerArray2;
                        n = handlerArray2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            object = handlerArray3[n2];
                            logger.removeHandler((Handler)object);
                            ++n2;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                handlerArray = LogUtil.createHandlers(properties);
            } else {
                handlerArray = handlerArray2;
            }
            object = logger.getLevel();
            if (object == null) {
                object = Level.WARNING;
            } else if (!bl && ((Level)object).intValue() < Level.WARNING.intValue()) {
                object = Level.WARNING;
                logger.setLevel((Level)object);
            }
            Handler[] handlerArray4 = handlerArray;
            int n3 = handlerArray.length;
            n = 0;
            while (n < n3) {
                Handler handler = handlerArray4[n];
                String string = handler.getClass().getName();
                Level level = LogUtil.getLevelProperty(properties, string, (Level)object);
                handler.setLevel(level);
                if (bl2) {
                    logger.addHandler(handler);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final synchronized void setupLogging() {
        if (initialized) {
            return;
        }
        initialized = true;
        boolean bl = LogUtil.loadProperties(null);
        if (Platform.isRunning()) {
            HookLogListener hookLogListener = new HookLogListener(LoggerFactory.getLogger((String)NAME_LOGGER_SYSTEM));
            Platform.addLogListener((ILogListener)hookLogListener);
        }
        LogUtil.setupHandlers(null, bl);
        UncaughtExceptionHandler.setupExceptionHandler();
    }

    private LogUtil() {
    }

    private static final class LogFilenameFilter
    implements FileFilter {
        private static final LogFilenameFilter INSTANCE = new LogFilenameFilter();
        private final Pattern pattern = Pattern.compile("dw\\.log(\\.\\d+|)");

        private LogFilenameFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && this.pattern.matcher(file.getName()).matches();
        }
    }

    private static final class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Logger LOG = LoggerFactory.getLogger((String)"deltawalker.eclipse");

        private UncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            this.LOG.error("Unhandled exception in thread " + thread, throwable);
        }

        private static final void setupExceptionHandler() {
            try {
                Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

