/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util.logging;

import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;

final class HookLogListener
implements ILogListener {
    private final Logger logger;

    private static final String formatMessage(IStatus iStatus, String string) {
        String string2 = iStatus.getMessage();
        StringBuilder stringBuilder = new StringBuilder(128);
        if (string != null && string.length() > 0) {
            stringBuilder.append(string).append(": ");
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    HookLogListener(Logger logger) {
        this.logger = logger;
    }

    public void logging(IStatus iStatus, String string) {
        if (this.logger == null || iStatus == null) {
            return;
        }
        int n = iStatus.getSeverity();
        switch (n) {
            case 1: {
                if (!this.logger.isInfoEnabled()) {
                    return;
                }
                this.logger.info(HookLogListener.formatMessage(iStatus, string), iStatus.getException());
                break;
            }
            case 2: {
                if (!this.logger.isWarnEnabled()) {
                    return;
                }
                this.logger.warn(HookLogListener.formatMessage(iStatus, string), iStatus.getException());
                break;
            }
            default: {
                if (!this.logger.isErrorEnabled()) {
                    return;
                }
                this.logger.error(HookLogListener.formatMessage(iStatus, string), iStatus.getException());
            }
        }
    }
}

