/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

final class ConsoleHandler
extends StreamHandler {
    public ConsoleHandler() {
        this.setOutputStream(new WrapOutputStream(System.out));
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            String string = this.getFormatter().format(logRecord);
            boolean bl = logRecord.getLevel().intValue() >= Level.WARNING.intValue();
            PrintStream printStream = bl ? System.err : System.out;
            printStream.print(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class WrapOutputStream
    extends OutputStream {
        private final PrintStream stream;

        private WrapOutputStream(PrintStream printStream) {
            this.stream = printStream;
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
        }

        @Override
        public void write(int n) throws IOException {
            this.stream.write(n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.stream.write(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.stream.write(byArray);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

