/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util;

import com.deltopia.util.Checker;
import java.nio.file.Paths;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class PathUtil {
    private PathUtil() {
    }

    public static final java.nio.file.Path canonize(java.nio.file.Path path) {
        Checker.notNull(path, "path");
        java.nio.file.Path path2 = path.toAbsolutePath();
        path2 = path2.normalize();
        return path2;
    }

    public static final java.nio.file.Path getCanonical(String string) {
        Checker.notNull(string, "strPath");
        return PathUtil.canonize(Paths.get(string, new String[0]));
    }

    public static final IPath[] toEclipsePaths(Set<java.nio.file.Path> set) {
        Checker.notNull(set, "paths");
        IPath[] iPathArray = new IPath[set.size()];
        int n = 0;
        for (java.nio.file.Path path : set) {
            Checker.notNull(path, "path");
            iPathArray[n++] = Path.fromOSString((String)path.toString());
        }
        return iPathArray;
    }
}

