/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util;

import com.deltopia.Msg;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OS {
    private static final Logger LOG = LoggerFactory.getLogger(OS.class);
    public static final boolean CARBON = "carbon".equals(Platform.getWS());
    public static final boolean COCOA = "cocoa".equals(Platform.getWS());
    public static final boolean GTK = "gtk".equals(Platform.getWS());
    public static final int JRE_VERSION;
    public static final boolean LINUX;
    public static final double OS_VERSION;
    public static final boolean OSX;
    public static final double OSX7 = 10.7;
    public static final boolean WIN;
    public static final double WIN6 = 6.0;
    public static final boolean X86_64;

    static {
        X86_64 = Platform.getOSArch().equals("x86_64");
        String string = Platform.getOS();
        LINUX = "linux".equals(string);
        OSX = "macosx".equals(string);
        WIN = "win32".equals(string);
        int n = 0;
        try {
            String string2 = System.getProperty("java.version");
            n = Integer.parseInt(string2.substring(2, 3));
        }
        catch (Exception exception) {
            LOG.error("Cannot parse JRE version", (Throwable)exception);
        }
        JRE_VERSION = n;
        double d = 0.0;
        try {
            String string3 = System.getProperty("os.version");
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            int n2 = 0;
            while (n2 < string3.length()) {
                char c = string3.charAt(n2);
                if ((c < '0' || c > '9') && (c != '.' || !bl)) break;
                if (c == '.') {
                    bl = false;
                }
                stringBuilder.append(c);
                ++n2;
            }
            d = Double.parseDouble(stringBuilder.toString());
        }
        catch (Exception exception) {
            LOG.error("Cannot parse OS version", (Throwable)exception);
        }
        OS_VERSION = d;
    }

    public static boolean isVersionEqualOrNewerThan(double d) {
        return OS_VERSION >= d;
    }

    public static String mod1Key() {
        if (OSX) {
            return Msg.OSHelper_mod1KeyOSX;
        }
        return Msg.OSHelper_mod1Key;
    }

    public static String resourceSuffix() {
        if (WIN) {
            return "win";
        }
        if (OSX) {
            return "osx";
        }
        if (GTK) {
            return "gtk";
        }
        return "";
    }

    private OS() {
    }
}

