/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util;

import com.deltopia.util.IDisposable;
import java.util.Collection;

public class LifecycleUtil {
    public static final <T extends IDisposable> void disposeAll(Collection<T> collection) {
        if (collection != null) {
            for (IDisposable iDisposable : collection) {
                if (iDisposable == null) continue;
                iDisposable.dispose();
            }
        }
    }

    public static final <T extends IDisposable> void disposeAll(T[] TArray) {
        if (TArray != null) {
            int n = 0;
            while (n < TArray.length) {
                T t = TArray[n];
                if (t != null) {
                    t.dispose();
                }
                ++n;
            }
        }
    }

    public static final void sleepSilently(long l) {
        if (l >= 0L) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException);
            }
        }
    }

    private LifecycleUtil() {
    }
}

