/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util;

import java.util.NoSuchElementException;

public final class CodePointIterator {
    private int lastIx;
    private final int length;
    private int nextIx;
    private final String str;

    public CodePointIterator(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("str");
        }
        this.str = string;
        this.length = string.length();
        this.reset();
    }

    public String getString() {
        return this.str;
    }

    public boolean hasNext() {
        return this.nextIx < this.length;
    }

    public int lastIndex() {
        return this.lastIx;
    }

    public int length() {
        return this.length;
    }

    public int next() throws NoSuchElementException {
        if (this.nextIx >= this.length) {
            throw new NoSuchElementException(String.valueOf(this.nextIx) + ">=" + this.length);
        }
        int n = this.str.codePointAt(this.nextIx);
        this.lastIx = this.nextIx;
        this.nextIx += Character.charCount(n);
        return n;
    }

    public int nextIndex() {
        return this.nextIx;
    }

    public void reset() {
        this.nextIx = 0;
        this.lastIx = -1;
    }

    public String toString() {
        return "string='" + this.str + '\'' + ", lastIndex=" + this.lastIx;
    }
}

