/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;

public final class Checker {
    private Checker() {
    }

    public static <T> T notNull(T t, String string) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException(string != null ? String.valueOf(string) + " is null" : "null object");
        }
        return t;
    }

    public static String notEmpty(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(string2 != null ? String.valueOf(string2) + " is null" : "null string");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException(string2 != null ? String.valueOf(string2) + " is empty" : "empty string");
        }
        return string;
    }

    public static <E, C extends Collection<E>> C notEmpty(C c, String string) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException(string != null ? String.valueOf(string) + " is null" : "null collection");
        }
        if (c.isEmpty()) {
            throw new IllegalArgumentException(string != null ? String.valueOf(string) + " is empty" : "empty collection");
        }
        return c;
    }

    public static <T> T[] notEmpty(T[] TArray, String string) throws IllegalArgumentException {
        if (TArray == null) {
            throw new IllegalArgumentException(string != null ? String.valueOf(string) + " is null" : "null collection");
        }
        if (TArray.length <= 0) {
            throw new IllegalArgumentException(string != null ? String.valueOf(string) + " is empty" : "empty collection");
        }
        return TArray;
    }

    public static <K, V, M extends Map<K, V>> M notEmpty(M m, String string) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException(string != null ? String.valueOf(string) + " is null" : "null map");
        }
        if (m.isEmpty()) {
            throw new IllegalArgumentException(string != null ? String.valueOf(string) + " is empty" : "empty map");
        }
        return m;
    }

    public static final Path notRoot(Path path, String string) {
        if (path == null) {
            throw new IllegalArgumentException(string != null ? String.valueOf(string) + " is null" : "null path");
        }
        if (path.getNameCount() == 0) {
            throw new IllegalArgumentException("Root path: " + path);
        }
        return path;
    }

    public static final void notSame(Path path, Path path2) {
        Checker.notNull(path, "srcPath");
        Checker.notNull(path2, "dstPath");
        if (path.equals(path2)) {
            throw new IllegalArgumentException("Source is " + path + " same as destination" + path2);
        }
    }
}

