/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.util;

import com.deltopia.ObjectUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ArrayUtil {
    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static <T> T[] copyOf(T[] TArray, int n) {
        return ArrayUtil.copyOf(TArray, n, TArray.getClass());
    }

    public static <T, U> T[] copyOf(U[] UArray, int n, Class<? extends T[]> clazz) {
        Object[] objectArray = clazz == Object[].class ? new Object[n] : (Object[])Array.newInstance(clazz.getComponentType(), n);
        System.arraycopy(UArray, 0, objectArray, 0, Math.min(UArray.length, n));
        return objectArray;
    }

    public static boolean equals(Object object, Object object2) {
        int n;
        int n2 = object == null ? 0 : Array.getLength(object);
        int n3 = n = object2 == null ? 0 : Array.getLength(object2);
        if (n2 != n) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (!ObjectUtil.areEqual(Array.get(object, n4), Array.get(object2, n4))) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static int indexOf(Object[] objectArray, int n, int n2, Object object) {
        int n3 = n;
        while (n3 < n2) {
            if (ObjectUtil.areEqual(objectArray[n3], object)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        return ArrayUtil.indexOf(objectArray, 0, objectArray.length, object);
    }

    public static Object join(Class<?> clazz, Object object, Object object2) {
        int n = object != null ? Array.getLength(object) : 0;
        int n2 = object2 != null ? Array.getLength(object2) : 0;
        Object object3 = Array.newInstance(clazz, n + n2);
        if (n > 0) {
            System.arraycopy(object, 0, object3, 0, n);
        }
        if (n2 > 0) {
            System.arraycopy(object2, 0, object3, n, n2);
        }
        return object3;
    }

    public static void print(Object[] objectArray, boolean bl) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (bl) {
                System.err.println(object != null ? object.toString() : "null");
            } else {
                System.out.println(object != null ? object.toString() : "null");
            }
            ++n2;
        }
    }

    private ArrayUtil() {
    }
}

