/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.regex;

import com.deltopia.regex.GroupNode;
import com.deltopia.regex.Node;
import com.deltopia.regex.PrimaryPattern;
import com.deltopia.util.CodePointIterator;
import com.deltopia.util.logging.ToString;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;

final class SecondaryPatternParser {
    private final CodePointIterator it;
    private final List<Node> nodes;
    private final StringBuilder normalizedRegex;
    private final PrimaryPattern primaryPattern;

    SecondaryPatternParser(String string, PrimaryPattern primaryPattern) throws NullPointerException, IllegalArgumentException {
        if (primaryPattern == null) {
            throw new NullPointerException("primaryPattern");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("Empty regex");
        }
        this.primaryPattern = primaryPattern;
        this.it = new CodePointIterator(string);
        this.nodes = new LinkedList<Node>();
        this.normalizedRegex = new StringBuilder(string.length());
    }

    int getMaxGroupIndex() {
        int n = -1;
        for (Node node : this.nodes) {
            if (!(node instanceof GroupNode)) continue;
            n = Math.max(n, ((GroupNode)node).groupIndex());
        }
        return n;
    }

    List<Node> nodes() {
        return this.nodes;
    }

    String normalizedRegex() {
        return this.normalizedRegex.toString();
    }

    final void parse() throws PatternSyntaxException {
        this.it.reset();
        this.nodes.clear();
        this.normalizedRegex.setLength(0);
        while (this.it.hasNext()) {
            int n = this.it.next();
            if (n == 92) {
                if (!this.it.hasNext()) {
                    throw new PatternSyntaxException("Single escape char at the end", this.it.getString(), this.it.lastIndex());
                }
                this.normalizedRegex.appendCodePoint(n);
                continue;
            }
            if (n == 40) {
                this.parseGroup();
                continue;
            }
            this.normalizedRegex.appendCodePoint(n);
        }
    }

    private final void parseGroup() throws PatternSyntaxException {
        int n;
        int n2;
        int n3 = this.it.lastIndex();
        int n4 = this.it.next();
        if (n4 != 36) {
            this.normalizedRegex.append('(');
            this.normalizedRegex.appendCodePoint(n4);
            return;
        }
        int n5 = n2 = this.it.lastIndex();
        while (this.it.hasNext()) {
            int n6 = this.it.next();
            if (!Character.isDigit(n6)) {
                if (n6 == 41) break;
                throw new PatternSyntaxException("Invalid group indicator " + n6, this.it.getString(), this.it.lastIndex());
            }
            n5 = this.it.lastIndex();
        }
        if (n2 >= n5) {
            throw new PatternSyntaxException("Invalid group index", this.it.getString(), n5);
        }
        String string = this.it.getString().substring(n2 + 1, n5 + 1);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PatternSyntaxException("Invalid group index " + string, this.it.getString(), n2 + 1);
        }
        if (n <= 0) {
            throw new PatternSyntaxException("Non-positive group index " + n, this.it.getString(), n2 + 1);
        }
        GroupNode groupNode = new GroupNode(n3, n);
        this.nodes.add(groupNode);
        String string2 = this.primaryPattern.getGroup(n);
        this.normalizedRegex.append("(").append(string2).append(")");
    }

    public String toString() {
        return new ToString().append("normalized", this.normalizedRegex).more().append(", nodes", this.nodes).toString();
    }
}

