/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.regex;

import com.deltopia.StringUtil;
import com.deltopia.util.CodePointIterator;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RegexUtil.class);
    private static final Pattern PORT_STAR_PATTERN = Pattern.compile("([^\\*])\\*([^\\*])");
    public static final int POSSIBLE_SEPARATOR = 4;
    public static final int REFERENCING_GROUPS = 2;
    public static final String REGEX_SEPARATOR = File.separator.equals("\\") ? "\\\\" : File.separator;
    static final String REGEX_NO_SEPARATOR = "[^" + REGEX_SEPARATOR + "]*";
    static final String REGEX_PREFIX = "(?:.*" + REGEX_SEPARATOR + "|)";
    static final String REGEX_SUFFIX = "(?:" + REGEX_SEPARATOR + ".*|)";
    public static final String SUB_EXPRESSION_SEPARATOR = File.pathSeparator;
    public static final int WRAP_WITH_GROUPS = 1;

    private static final void convertStar(int n, StringBuilder stringBuilder, int n2, int n3) {
        if ((n2 & 1) != 0) {
            stringBuilder.append('(');
        }
        if ((n2 & 2) != 0) {
            stringBuilder.append('$').append(n3);
        } else if ((n2 & 4) != 0 && n == 1) {
            stringBuilder.append(REGEX_NO_SEPARATOR);
        } else {
            stringBuilder.append(".*");
        }
        if ((n2 & 1) != 0) {
            stringBuilder.append(')');
        }
    }

    public static String upgradeShellex(String string) throws PatternSyntaxException {
        String[] stringArray = string.split(SUB_EXPRESSION_SEPARATOR);
        if (stringArray.length > 1) {
            Object[] objectArray = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                objectArray[n] = RegexUtil.upgradeShellexSingle(stringArray[n].trim());
                ++n;
            }
            return StringUtil.join(objectArray, SUB_EXPRESSION_SEPARATOR);
        }
        return RegexUtil.upgradeShellexSingle(string);
    }

    private static String upgradeShellexSingle(String string) {
        if (string == null) {
            throw new NullPointerException("shellex");
        }
        if (string.length() <= 0) {
            throw new PatternSyntaxException("Empty shell expression", string, -1);
        }
        int n = string.indexOf(File.separatorChar);
        if (n < 0) {
            string = PORT_STAR_PATTERN.matcher(string).replaceAll("$1**$2");
        }
        return string;
    }

    public static String shell2regex(String string, int n) throws NullPointerException, PatternSyntaxException {
        String[] stringArray = string.split(SUB_EXPRESSION_SEPARATOR);
        if (stringArray.length > 1) {
            Object[] objectArray = new String[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                objectArray[n2] = RegexUtil.shell2regexSingle(stringArray[n2].trim(), n);
                ++n2;
            }
            return String.valueOf('(') + StringUtil.join(objectArray, ")|(") + ')';
        }
        return RegexUtil.shell2regexSingle(string, n);
    }

    public static final String shell2regexSingle(String string, int n) throws NullPointerException, PatternSyntaxException {
        if (string == null) {
            throw new NullPointerException("shellex");
        }
        if (string.length() <= 0) {
            throw new PatternSyntaxException("Empty shell expression", string, -1);
        }
        CodePointIterator codePointIterator = new CodePointIterator(string);
        StringBuilder stringBuilder = new StringBuilder(codePointIterator.length());
        StringBuilder stringBuilder2 = new StringBuilder(codePointIterator.length());
        int n2 = 0;
        int n3 = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (codePointIterator.hasNext()) {
            int n4 = codePointIterator.next();
            boolean bl4 = false;
            String string2 = null;
            if (n4 == File.separatorChar) {
                bl3 = true;
                if (codePointIterator.lastIndex() == 0) {
                    if (!codePointIterator.hasNext()) {
                        throw new PatternSyntaxException("Single separator only", string, 0);
                    }
                    bl = true;
                } else if (!codePointIterator.hasNext()) {
                    bl2 = true;
                } else {
                    bl4 = true;
                }
            } else if (n4 == 42) {
                ++n2;
            } else if (n4 == 63) {
                string2 = ".";
            } else {
                bl4 = true;
            }
            if (n4 != 42 && n2 > 0) {
                RegexUtil.convertStar(n2, stringBuilder, n, n3);
                n2 = 0;
            }
            if (bl4) {
                stringBuilder2.appendCodePoint(n4);
                continue;
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder.append(Pattern.quote(stringBuilder2.toString()));
                stringBuilder2.setLength(0);
            }
            if (string2 == null) continue;
            if ((n & 1) != 0) {
                stringBuilder.append("(").append(string2).append(")");
                continue;
            }
            stringBuilder.append(string2);
        }
        if (n2 > 0) {
            RegexUtil.convertStar(n2, stringBuilder, n, n3);
        } else if (stringBuilder2.length() > 0) {
            stringBuilder.append(Pattern.quote(stringBuilder2.toString()));
        }
        if (!bl) {
            if (!bl3) {
                stringBuilder.insert(0, REGEX_PREFIX);
            }
        } else {
            stringBuilder.insert(0, '^');
        }
        if (!bl2) {
            if (!bl3) {
                stringBuilder.append(REGEX_SUFFIX);
            }
        } else {
            stringBuilder.append('$');
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Convert '" + string + "' -> '" + stringBuilder + '\'');
        }
        return stringBuilder.toString();
    }
}

