/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.regex;

import com.deltopia.regex.ASCII;
import com.deltopia.util.logging.ToString;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PrimaryPattern {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.structure.internal.PrimaryPattern");
    private String pattern;
    private int flags;
    private transient String normalizedPattern;
    Node root;
    Node matchRoot;
    int[] buffer;
    GroupHead[] groupNodes;
    private int[] temp;
    int capturingGroupCount;
    int localCount;
    private int cursor;
    private int patternLength;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node lookbehindEnd = new Node(){};
    static Node accept = new Node();
    static Node lastAccept = new LastNode();

    public static PrimaryPattern compile(String string, int n) {
        return new PrimaryPattern(string, n);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    public int flags() {
        return this.flags;
    }

    private PrimaryPattern(String string, int n) {
        this.pattern = string;
        this.flags = n;
        this.capturingGroupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
        }
    }

    private void normalize() {
        int n = -1;
        this.normalizedPattern = Normalizer.normalize(this.pattern, Normalizer.Form.NFD);
        this.patternLength = this.normalizedPattern.length();
        StringBuilder stringBuilder = new StringBuilder(this.patternLength);
        int n2 = 0;
        while (n2 < this.patternLength) {
            int n3 = this.normalizedPattern.codePointAt(n2);
            if (Character.getType(n3) == 6 && n != -1) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.appendCodePoint(n);
                stringBuilder2.appendCodePoint(n3);
                while (Character.getType(n3) == 6) {
                    if ((n2 += Character.charCount(n3)) >= this.patternLength) break;
                    n3 = this.normalizedPattern.codePointAt(n2);
                    stringBuilder2.appendCodePoint(n3);
                }
                String string = this.produceEquivalentAlternation(stringBuilder2.toString());
                stringBuilder.setLength(stringBuilder.length() - Character.charCount(n));
                stringBuilder.append("(?:").append(string).append(")");
            } else if (n3 == 91 && n != 92) {
                n2 = this.normalizeCharClass(stringBuilder, n2);
            } else {
                stringBuilder.appendCodePoint(n3);
            }
            n = n3;
            n2 += Character.charCount(n3);
        }
        this.normalizedPattern = stringBuilder.toString();
    }

    private int normalizeCharClass(StringBuilder stringBuilder, int n) {
        int n2;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = null;
        int n3 = -1;
        ++n;
        stringBuilder2.append("[");
        while (true) {
            if ((n2 = this.normalizedPattern.codePointAt(n)) == 93 && n3 != 92) break;
            if (Character.getType(n2) == 6) {
                StringBuilder stringBuilder4 = new StringBuilder();
                stringBuilder4.appendCodePoint(n3);
                while (Character.getType(n2) == 6) {
                    stringBuilder4.appendCodePoint(n2);
                    if ((n += Character.charCount(n2)) >= this.normalizedPattern.length()) break;
                    n2 = this.normalizedPattern.codePointAt(n);
                }
                String string = this.produceEquivalentAlternation(stringBuilder4.toString());
                stringBuilder2.setLength(stringBuilder2.length() - Character.charCount(n3));
                if (stringBuilder3 == null) {
                    stringBuilder3 = new StringBuilder();
                }
                stringBuilder3.append('|');
                stringBuilder3.append(string);
            } else {
                stringBuilder2.appendCodePoint(n2);
                ++n;
            }
            if (n == this.normalizedPattern.length()) {
                throw this.error("Unclosed character class");
            }
            n3 = n2;
        }
        stringBuilder2.append((char)n2);
        String string = stringBuilder3 != null ? "(?:" + stringBuilder2.toString() + stringBuilder3.toString() + ")" : stringBuilder2.toString();
        stringBuilder.append(string);
        return n;
    }

    private String produceEquivalentAlternation(String string) {
        int n = PrimaryPattern.countChars(string, 0, 1);
        if (string.length() == n) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        String[] stringArray = this.producePermutations(string3);
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string4 = String.valueOf(string2) + stringArray[n2];
            if (n2 > 0) {
                stringBuilder.append("|").append(string4);
            }
            if ((string4 = this.composeOneStep(string4)) != null) {
                stringBuilder.append("|").append(this.produceEquivalentAlternation(string4));
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private String[] producePermutations(String string) {
        int n;
        if (string.length() == PrimaryPattern.countChars(string, 0, 1)) {
            return new String[]{string};
        }
        if (string.length() == PrimaryPattern.countChars(string, 0, 2)) {
            int n2 = Character.codePointAt(string, 0);
            int n3 = Character.codePointAt(string, Character.charCount(n2));
            if (this.getClass(n3) == this.getClass(n2)) {
                return new String[]{string};
            }
            String[] stringArray = new String[2];
            stringArray[0] = string;
            StringBuilder stringBuilder = new StringBuilder(2);
            stringBuilder.appendCodePoint(n3);
            stringBuilder.appendCodePoint(n2);
            stringArray[1] = stringBuilder.toString();
            return stringArray;
        }
        int n4 = 1;
        int n5 = PrimaryPattern.countCodePoints(string);
        int n6 = 1;
        while (n6 < n5) {
            n4 *= n6 + 1;
            ++n6;
        }
        String[] stringArray = new String[n4];
        int[] nArray = new int[n5];
        int n7 = 0;
        int n8 = 0;
        while (n7 < n5) {
            n = Character.codePointAt(string, n8);
            nArray[n7] = this.getClass(n);
            n8 += Character.charCount(n);
            ++n7;
        }
        n7 = 0;
        n = 0;
        int n9 = 0;
        while (n < n5) {
            block10: {
                n8 = PrimaryPattern.countChars(string, n9, 1);
                int n10 = n - 1;
                while (n10 >= 0) {
                    if (nArray[n10] != nArray[n]) {
                        --n10;
                        continue;
                    }
                    break block10;
                }
                StringBuilder stringBuilder = new StringBuilder(string);
                String string2 = stringBuilder.delete(n9, n9 + n8).toString();
                String[] stringArray2 = this.producePermutations(string2);
                String string3 = string.substring(n9, n9 + n8);
                int n11 = 0;
                while (n11 < stringArray2.length) {
                    stringArray[n7++] = String.valueOf(string3) + stringArray2[n11];
                    ++n11;
                }
            }
            ++n;
            n9 += n8;
        }
        String[] stringArray3 = new String[n7];
        n9 = 0;
        while (n9 < n7) {
            stringArray3[n9] = stringArray[n9];
            ++n9;
        }
        return stringArray3;
    }

    private int getClass(int n) {
        return sun.text.Normalizer.getCombiningClass(n);
    }

    private String composeOneStep(String string) {
        int n = PrimaryPattern.countChars(string, 0, 2);
        String string2 = string.substring(0, n);
        String string3 = Normalizer.normalize(string2, Normalizer.Form.NFC);
        if (string3.equals(string2)) {
            return null;
        }
        String string4 = string.substring(n);
        return String.valueOf(string3) + string4;
    }

    private void RemoveQEQuoting() {
        int n = this.patternLength;
        int n2 = 0;
        while (n2 < n - 1) {
            if (this.temp[n2] != 92) {
                ++n2;
                continue;
            }
            if (this.temp[n2 + 1] == 81) break;
            n2 += 2;
        }
        if (n2 >= n - 1) {
            return;
        }
        int n3 = n2;
        int[] nArray = new int[n3 + 2 * (n - (n2 += 2)) + 2];
        System.arraycopy(this.temp, 0, nArray, 0, n3);
        boolean bl = true;
        while (n2 < n) {
            int n4;
            if (!ASCII.isAscii(n4 = this.temp[n2++]) || ASCII.isAlnum(n4)) {
                nArray[n3++] = n4;
                continue;
            }
            if (n4 != 92) {
                if (bl) {
                    nArray[n3++] = 92;
                }
                nArray[n3++] = n4;
                continue;
            }
            if (bl) {
                if (this.temp[n2] == 69) {
                    ++n2;
                    bl = false;
                    continue;
                }
                nArray[n3++] = 92;
                nArray[n3++] = 92;
                continue;
            }
            if (this.temp[n2] == 81) {
                ++n2;
                bl = true;
                continue;
            }
            nArray[n3++] = n4;
            if (n2 == n) continue;
            nArray[n3++] = this.temp[n2++];
        }
        this.patternLength = n3;
        this.temp = Arrays.copyOf(nArray, n3 + 2);
    }

    private void compile() {
        if (this.has(128) && !this.has(16)) {
            this.normalize();
        } else {
            this.normalizedPattern = this.pattern;
        }
        this.patternLength = this.normalizedPattern.length();
        this.temp = new int[this.patternLength + 2];
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < this.patternLength) {
            int n3 = this.normalizedPattern.codePointAt(n2);
            if (PrimaryPattern.isSupplementary(n3)) {
                bl = true;
            }
            this.temp[n++] = n3;
            n2 += Character.charCount(n3);
        }
        this.patternLength = n;
        if (!this.has(16)) {
            this.RemoveQEQuoting();
        }
        this.buffer = new int[32];
        this.groupNodes = new GroupHead[10];
        if (this.has(16)) {
            this.matchRoot = this.newSlice(this.temp, this.patternLength, bl);
            this.matchRoot.next = lastAccept;
        } else {
            this.matchRoot = this.expr(lastAccept);
            if (this.patternLength != this.cursor) {
                if (this.peek() == 41) {
                    throw this.error("Unmatched closing ')'");
                }
                throw this.error("Unexpected internal error");
            }
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (this.root == this.matchRoot) {
                this.root = bl ? new StartS(this.matchRoot) : new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin || this.matchRoot instanceof First ? this.matchRoot : (bl ? new StartS(this.matchRoot) : new Start(this.matchRoot));
        }
        this.temp = null;
        this.buffer = null;
        this.groupNodes = null;
        this.patternLength = 0;
    }

    private int toStringNodes(int n, Node node, ToString toString) {
        while (node != null) {
            toString.append("" + n, node, true);
            ++n;
            if (node instanceof Branch) {
                Branch branch = (Branch)node;
                toString.more();
                n = this.toStringNodes(n, branch.conn, toString);
                toString.more();
                int n2 = 0;
                while (n2 < branch.atoms.length) {
                    this.toStringNodes(n, branch.atoms[n2], toString);
                    ++n2;
                }
                toString.less();
                toString.less();
            }
            node = node.next;
        }
        return n;
    }

    String toStringNodes() {
        ToString toString = new ToString();
        this.toStringNodes(0, this.root, toString);
        return toString.toString();
    }

    public int getGroupCount() {
        return this.capturingGroupCount - 1;
    }

    private String findGroup(int n, Node node, GroupHead groupHead) {
        GroupTail groupTail = null;
        while (node != null) {
            if (node instanceof GroupHead) {
                if (groupHead == null && ((GroupHead)node).groupIndex == n) {
                    groupHead = (GroupHead)node;
                }
            } else if (node instanceof GroupTail && ((GroupTail)node).groupIndex == n) {
                groupTail = (GroupTail)node;
                break;
            }
            if (node instanceof Branch) {
                Branch branch = (Branch)node;
                String string = this.findGroup(n, branch.conn, groupHead);
                if (string != null) {
                    return string;
                }
                int n2 = 0;
                while (n2 < branch.atoms.length) {
                    string = this.findGroup(n, branch.atoms[n2], groupHead);
                    if (string != null) {
                        return string;
                    }
                    ++n2;
                }
            }
            node = node.next;
        }
        if (groupHead == null || groupTail == null) {
            return null;
        }
        return this.pattern.substring(groupHead.position, groupTail.position);
    }

    public String getGroup(int n) throws PatternSyntaxException {
        if (n <= 0) {
            throw new IllegalArgumentException("groupIndex " + n);
        }
        String string = this.findGroup(n, this.root, null);
        if (string == null) {
            throw new PatternSyntaxException("Invalid group " + n, this.pattern, -1);
        }
        return string;
    }

    private boolean has(int n) {
        return (this.flags & n) != 0;
    }

    private void accept(int n, String string) {
        int n2 = this.temp[this.cursor++];
        if (this.has(4)) {
            n2 = this.parsePastWhitespace(n2);
        }
        if (n != n2) {
            throw this.error(string);
        }
    }

    private void mark(int n) {
        this.temp[this.patternLength] = n;
    }

    private int peek() {
        int n = this.temp[this.cursor];
        if (this.has(4)) {
            n = this.peekPastWhitespace(n);
        }
        return n;
    }

    private int read() {
        int n = this.temp[this.cursor++];
        if (this.has(4)) {
            n = this.parsePastWhitespace(n);
        }
        return n;
    }

    private int readEscaped() {
        int n = this.temp[this.cursor++];
        return n;
    }

    private int next() {
        int n = this.temp[++this.cursor];
        if (this.has(4)) {
            n = this.peekPastWhitespace(n);
        }
        return n;
    }

    private int nextEscaped() {
        int n = this.temp[++this.cursor];
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int peekPastWhitespace(int var1_1) {
        ** GOTO lbl7
        {
            var1_1 = this.temp[++this.cursor];
            do {
                if (ASCII.isSpace(var1_1)) continue block0;
                if (var1_1 != 35) continue;
                var1_1 = this.peekPastLine();
lbl7:
                // 3 sources

            } while (ASCII.isSpace(var1_1) || var1_1 == 35);
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    private int parsePastWhitespace(int var1_1) {
        ** GOTO lbl7
        {
            var1_1 = this.temp[this.cursor++];
            do {
                if (ASCII.isSpace(var1_1)) continue block0;
                if (var1_1 != 35) continue;
                var1_1 = this.parsePastLine();
lbl7:
                // 3 sources

            } while (ASCII.isSpace(var1_1) || var1_1 == 35);
        }
        return var1_1;
    }

    private int parsePastLine() {
        int n = this.temp[this.cursor++];
        while (n != 0 && !this.isLineSeparator(n)) {
            n = this.temp[this.cursor++];
        }
        return n;
    }

    private int peekPastLine() {
        int n = this.temp[++this.cursor];
        while (n != 0 && !this.isLineSeparator(n)) {
            n = this.temp[++this.cursor];
        }
        return n;
    }

    private boolean isLineSeparator(int n) {
        if (this.has(1)) {
            return n == 10;
        }
        return n == 10 || n == 13 || (n | 1) == 8233 || n == 133;
    }

    private int skip() {
        int n = this.cursor;
        int n2 = this.temp[n + 1];
        this.cursor = n + 2;
        return n2;
    }

    private void unread() {
        --this.cursor;
    }

    private PatternSyntaxException error(String string) {
        return new PatternSyntaxException(string, this.normalizedPattern, this.cursor - 1);
    }

    private boolean findSupplementary(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (PrimaryPattern.isSupplementary(this.temp[n3])) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private static final boolean isSupplementary(int n) {
        return n >= 65536 || PrimaryPattern.isSurrogate(n);
    }

    private Node expr(Node node) {
        Node node2 = null;
        Node node3 = null;
        BranchConn branchConn = null;
        while (true) {
            Node node4 = this.sequence(node);
            Node node5 = this.root;
            if (node2 == null) {
                node2 = node4;
                node3 = node5;
            } else {
                if (branchConn == null) {
                    branchConn = new BranchConn();
                    branchConn.next = node;
                }
                if (node4 == node) {
                    node4 = null;
                } else {
                    node5.next = branchConn;
                }
                if (node2 instanceof Branch) {
                    ((Branch)node2).add(node4);
                } else {
                    if (node2 == node) {
                        node2 = null;
                    } else {
                        node3.next = branchConn;
                    }
                    node2 = new Branch(node2, node4, branchConn);
                }
            }
            if (this.peek() != 124) {
                return node2;
            }
            this.next();
        }
    }

    private Node sequence(Node node) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        block12: while (true) {
            int n = this.peek();
            switch (n) {
                case 40: {
                    node4 = this.group0();
                    if (node4 == null) continue block12;
                    if (node2 == null) {
                        node2 = node4;
                    } else {
                        node3.next = node4;
                    }
                    node3 = this.root;
                    continue block12;
                }
                case 91: {
                    node4 = this.clazz(true);
                    break;
                }
                case 92: {
                    n = this.nextEscaped();
                    if (n == 112 || n == 80) {
                        boolean bl = true;
                        boolean bl2 = n == 80;
                        n = this.next();
                        if (n != 123) {
                            this.unread();
                        } else {
                            bl = false;
                        }
                        node4 = this.family(bl).maybeComplement(bl2);
                        break;
                    }
                    this.unread();
                    node4 = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node4 = new UnixCaret();
                            break;
                        }
                        node4 = new Caret();
                        break;
                    }
                    node4 = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node4 = new UnixDollar(this.has(8));
                        break;
                    }
                    node4 = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node4 = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node4 = new UnixDot();
                        break;
                    }
                    node4 = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node4 = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    throw this.error("Dangling meta character '" + (char)n + "'");
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node4 = this.atom();
                }
            }
            node4 = this.closure(node4);
            if (node2 == null) {
                node2 = node3 = node4;
                continue;
            }
            node3.next = node4;
            node3 = node4;
        }
        if (node2 == null) {
            return node;
        }
        node3.next = node;
        this.root = node3;
        return node2;
    }

    private Node atom() {
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        int n3 = this.peek();
        block6: while (true) {
            switch (n3) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (n <= true) break block6;
                    this.cursor = n2;
                    --n;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    n3 = this.nextEscaped();
                    if (n3 == 112 || n3 == 80) {
                        if (n > 0) {
                            this.unread();
                            break block6;
                        }
                        boolean bl2 = n3 == 80;
                        boolean bl3 = true;
                        n3 = this.next();
                        if (n3 != 123) {
                            this.unread();
                        } else {
                            bl3 = false;
                        }
                        return this.family(bl3).maybeComplement(bl2);
                    }
                    this.unread();
                    n2 = this.cursor;
                    n3 = this.escape(false, n == 0);
                    if (n3 >= 0) {
                        this.append(n3, n);
                        ++n;
                        if (PrimaryPattern.isSupplementary(n3)) {
                            bl = true;
                        }
                        n3 = this.peek();
                        continue block6;
                    }
                    if (n == 0) {
                        return this.root;
                    }
                    this.cursor = n2;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    n2 = this.cursor;
                    this.append(n3, n);
                    ++n;
                    if (PrimaryPattern.isSupplementary(n3)) {
                        bl = true;
                    }
                    n3 = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (n == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, n, bl);
    }

    private void append(int n, int n2) {
        if (n2 >= this.buffer.length) {
            int[] nArray = new int[n2 + n2];
            System.arraycopy(this.buffer, 0, nArray, 0, n2);
            this.buffer = nArray;
        }
        this.buffer[n2] = n;
    }

    private Node ref(int n) {
        boolean bl = false;
        while (!bl) {
            int n2 = this.peek();
            switch (n2) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int n3 = n * 10 + (n2 - 48);
                    if (this.capturingGroupCount - 1 < n3) {
                        bl = true;
                        break;
                    }
                    n = n3;
                    this.read();
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (this.has(2)) {
            return new CIBackRef(n, this.has(64));
        }
        return new BackRef(n);
    }

    private int escape(boolean bl, boolean bl2) {
        int n = this.skip();
        switch (n) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (bl) break;
                if (bl2) {
                    this.root = this.ref(n - 48);
                }
                return -1;
            }
            case 65: {
                if (bl) break;
                if (bl2) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.NONE);
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (bl2) {
                    this.root = new Ctype(1024).complement();
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (bl) break;
                if (bl2) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                break;
            }
            case 83: {
                if (bl2) {
                    this.root = new Ctype(2048).complement();
                }
                return -1;
            }
            case 84: 
            case 85: 
            case 86: {
                break;
            }
            case 87: {
                if (bl2) {
                    this.root = new Ctype(67328).complement();
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (bl) break;
                if (bl2) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.BOTH);
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (bl2) {
                    this.root = new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (bl2) {
                    this.root = new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                return 11;
            }
            case 119: {
                if (bl2) {
                    this.root = new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (bl) break;
                if (bl2) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return n;
            }
        }
        throw this.error("Illegal/unsupported escape sequence");
    }

    private CharProperty clazz(boolean bl) {
        CharProperty charProperty = null;
        CharProperty charProperty2 = null;
        BitClass bitClass = new BitClass();
        boolean bl2 = true;
        boolean bl3 = true;
        int n = this.next();
        block7: while (true) {
            switch (n) {
                case 94: {
                    if (!bl3 || this.temp[this.cursor - 1] != 91) break;
                    n = this.next();
                    bl2 = !bl2;
                    continue block7;
                }
                case 91: {
                    bl3 = false;
                    charProperty2 = this.clazz(true);
                    charProperty = charProperty == null ? charProperty2 : PrimaryPattern.union(charProperty, charProperty2);
                    n = this.peek();
                    continue block7;
                }
                case 38: {
                    bl3 = false;
                    n = this.next();
                    if (n == 38) {
                        n = this.next();
                        CharProperty charProperty3 = null;
                        while (n != 93 && n != 38) {
                            if (n == 91) {
                                charProperty3 = charProperty3 == null ? this.clazz(true) : PrimaryPattern.union(charProperty3, this.clazz(true));
                            } else {
                                this.unread();
                                charProperty3 = this.clazz(false);
                            }
                            n = this.peek();
                        }
                        if (charProperty3 != null) {
                            charProperty2 = charProperty3;
                        }
                        if (charProperty == null) {
                            if (charProperty3 == null) {
                                throw this.error("Bad class syntax");
                            }
                            charProperty = charProperty3;
                            continue block7;
                        }
                        charProperty = PrimaryPattern.intersection(charProperty, charProperty2);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    bl3 = false;
                    if (this.cursor < this.patternLength) break;
                    throw this.error("Unclosed character class");
                }
                case 93: {
                    bl3 = false;
                    if (charProperty == null) break;
                    if (bl) {
                        this.next();
                    }
                    return charProperty;
                }
                default: {
                    bl3 = false;
                }
            }
            charProperty2 = this.range(bitClass);
            if (bl2) {
                if (charProperty == null) {
                    charProperty = charProperty2;
                } else if (charProperty != charProperty2) {
                    charProperty = PrimaryPattern.union(charProperty, charProperty2);
                }
            } else if (charProperty == null) {
                charProperty = charProperty2.complement();
            } else if (charProperty != charProperty2) {
                charProperty = PrimaryPattern.setDifference(charProperty, charProperty2);
            }
            n = this.peek();
        }
    }

    private CharProperty bitsOrSingle(BitClass bitClass, int n) {
        if (n < 256 && (!this.has(2) || !this.has(64) || n != 255 && n != 181 && n != 73 && n != 105 && n != 83 && n != 115 && n != 75 && n != 107 && n != 197 && n != 229)) {
            return bitClass.add(n, this.flags());
        }
        return this.newSingle(n);
    }

    private CharProperty range(BitClass bitClass) {
        int n = this.peek();
        if (n == 92) {
            n = this.nextEscaped();
            if (n == 112 || n == 80) {
                boolean bl = n == 80;
                boolean bl2 = true;
                n = this.next();
                if (n != 123) {
                    this.unread();
                } else {
                    bl2 = false;
                }
                return this.family(bl2).maybeComplement(bl);
            }
            this.unread();
            n = this.escape(true, true);
            if (n == -1) {
                return (CharProperty)this.root;
            }
        } else {
            n = this.single();
        }
        if (n >= 0) {
            if (this.peek() == 45) {
                int n2 = this.temp[this.cursor + 1];
                if (n2 == 91) {
                    return this.bitsOrSingle(bitClass, n);
                }
                if (n2 != 93) {
                    this.next();
                    int n3 = this.single();
                    if (n3 < n) {
                        throw this.error("Illegal character range");
                    }
                    if (this.has(2)) {
                        return this.caseInsensitiveRangeFor(n, n3);
                    }
                    return PrimaryPattern.rangeFor(n, n3);
                }
            }
            return this.bitsOrSingle(bitClass, n);
        }
        throw this.error("Unexpected character '" + (char)n + "'");
    }

    private int single() {
        int n = this.peek();
        switch (n) {
            case 92: {
                return this.escape(true, false);
            }
        }
        this.next();
        return n;
    }

    private CharProperty family(boolean bl) {
        String string;
        this.next();
        if (bl) {
            int n = this.temp[this.cursor];
            string = !Character.isSupplementaryCodePoint(n) ? String.valueOf((char)n) : new String(this.temp, this.cursor, 1);
            this.read();
        } else {
            int n = this.cursor;
            this.mark(125);
            while (this.read() != 125) {
            }
            this.mark(0);
            int n2 = this.cursor;
            if (n2 > this.patternLength) {
                throw this.error("Unclosed character family");
            }
            if (n + 1 >= n2) {
                throw this.error("Empty character family");
            }
            string = new String(this.temp, n, n2 - n - 1);
        }
        if (string.startsWith("In")) {
            return this.unicodeBlockPropertyFor(string.substring(2));
        }
        if (string.startsWith("Is")) {
            string = string.substring(2);
        }
        return this.charPropertyNodeFor(string);
    }

    private CharProperty unicodeBlockPropertyFor(String string) {
        Character.UnicodeBlock unicodeBlock;
        try {
            unicodeBlock = Character.UnicodeBlock.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.error("Unknown character block name {" + string + "}");
        }
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n) {
                return unicodeBlock == Character.UnicodeBlock.of(n);
            }
        };
    }

    private CharProperty charPropertyNodeFor(String string) {
        CharProperty charProperty = CharPropertyNames.charPropertyFor(string);
        if (charProperty == null) {
            throw this.error("Unknown character property name {" + string + "}");
        }
        return charProperty;
    }

    private Node group0() {
        Object object;
        boolean bl = false;
        Node node = null;
        Node node2 = null;
        int n = this.flags;
        this.root = null;
        int n2 = this.next();
        if (n2 == 63) {
            n2 = this.skip();
            switch (n2) {
                case 58: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
                case 33: 
                case 61: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    if (n2 == 61) {
                        node = node2 = new Pos(node);
                        break;
                    }
                    node = node2 = new Neg(node);
                    break;
                }
                case 62: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    node = node2 = new Ques(node, 3);
                    break;
                }
                case 60: {
                    n2 = this.read();
                    int n3 = this.cursor;
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    node2.next = lookbehindEnd;
                    object = new TreeInfo();
                    node.study((TreeInfo)object);
                    if (!((TreeInfo)object).maxValid) {
                        throw this.error("Look-behind group does not have an obvious maximum length");
                    }
                    boolean bl2 = this.findSupplementary(n3, this.patternLength);
                    if (n2 == 61) {
                        node2 = bl2 ? new BehindS(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength) : new Behind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        node = node2;
                        break;
                    }
                    if (n2 == 33) {
                        node2 = bl2 ? new NotBehindS(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength) : new NotBehind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        node = node2;
                        break;
                    }
                    throw this.error("Unknown look-behind group");
                }
                case 36: 
                case 64: {
                    throw this.error("Unknown group type");
                }
                default: {
                    this.unread();
                    this.addFlag();
                    n2 = this.read();
                    if (n2 == 41) {
                        return null;
                    }
                    if (n2 != 58) {
                        throw this.error("Unknown inline modifier");
                    }
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
            }
        } else {
            bl = true;
            node = this.createGroup(false);
            node2 = this.root;
            node.next = this.expr(node2);
        }
        if (node2 instanceof GroupTail) {
            ((GroupTail)node2).setPosition(this.cursor);
        } else {
            LOG.warn("Unknown tail node " + node2 + " [" + this.cursor + "] pattern: " + this);
        }
        this.accept(41, "Unclosed group");
        this.flags = n;
        Node node3 = this.closure(node);
        if (node3 == node) {
            this.root = node2;
            return node3;
        }
        if (node == node2) {
            this.root = node3;
            return node3;
        }
        if (node3 instanceof Ques) {
            object = (Ques)node3;
            if (((Ques)object).type == 2) {
                this.root = node3;
                return node3;
            }
            node2 = node2.next = new BranchConn();
            node = ((Ques)object).type == 0 ? new Branch(node, null, node2) : new Branch(null, node, node2);
            this.root = node2;
            return node;
        }
        if (node3 instanceof Curly) {
            object = (Curly)node3;
            if (((Curly)object).type == 2) {
                this.root = node3;
                return node3;
            }
            TreeInfo treeInfo = new TreeInfo();
            if (node.study(treeInfo)) {
                GroupTail cfr_ignored_0 = (GroupTail)node2;
                node = this.root = new GroupCurly(node.next, ((Curly)object).cmin, ((Curly)object).cmax, ((Curly)object).type, ((GroupTail)node2).localIndex, ((GroupTail)node2).groupIndex, bl);
                return node;
            }
            int n4 = ((GroupHead)node).localIndex;
            Loop loop = ((Curly)object).type == 0 ? new Loop(this.localCount, n4) : new LazyLoop(this.localCount, n4);
            Prolog prolog = new Prolog(loop);
            ++this.localCount;
            loop.cmin = ((Curly)object).cmin;
            loop.cmax = ((Curly)object).cmax;
            loop.body = node;
            node2.next = loop;
            this.root = loop;
            return prolog;
        }
        throw this.error("Internal logic error");
    }

    private Node createGroup(boolean bl) {
        int n = this.localCount++;
        int n2 = 0;
        if (!bl) {
            n2 = this.capturingGroupCount++;
        }
        GroupHead groupHead = new GroupHead(bl, n, n2, this.cursor);
        this.root = new GroupTail(bl, n, n2);
        if (!bl && n2 < 10) {
            this.groupNodes[n2] = groupHead;
        }
        return groupHead;
    }

    private void addFlag() {
        int n = this.peek();
        while (true) {
            switch (n) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 99: {
                    this.flags |= 0x80;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 45: {
                    n = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            n = this.next();
        }
    }

    private void subFlag() {
        int n = this.peek();
        while (true) {
            switch (n) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 99: {
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                default: {
                    return;
                }
            }
            n = this.next();
        }
    }

    private Node closure(Node node) {
        int n = this.peek();
        switch (n) {
            case 63: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Ques(node, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Ques(node, 2);
                }
                return new Ques(node, 0);
            }
            case 42: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 0, Integer.MAX_VALUE, 0);
            }
            case 43: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 1, Integer.MAX_VALUE, 0);
            }
            case 123: {
                n = this.temp[this.cursor + 1];
                if (ASCII.isDigit(n)) {
                    Curly curly;
                    this.skip();
                    int n2 = 0;
                    do {
                        n2 = n2 * 10 + (n - 48);
                    } while (ASCII.isDigit(n = this.read()));
                    int n3 = n2;
                    if (n == 44) {
                        n = this.read();
                        n3 = Integer.MAX_VALUE;
                        if (n != 125) {
                            n3 = 0;
                            while (ASCII.isDigit(n)) {
                                n3 = n3 * 10 + (n - 48);
                                n = this.read();
                            }
                        }
                    }
                    if (n != 125) {
                        throw this.error("Unclosed counted closure");
                    }
                    if ((n2 | n3 | n3 - n2) < 0) {
                        throw this.error("Illegal repetition range");
                    }
                    n = this.peek();
                    if (n == 63) {
                        this.next();
                        curly = new Curly(node, n2, n3, 1);
                    } else if (n == 43) {
                        this.next();
                        curly = new Curly(node, n2, n3, 2);
                    } else {
                        curly = new Curly(node, n2, n3, 0);
                    }
                    return curly;
                }
                throw this.error("Illegal repetition");
            }
        }
        return node;
    }

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        throw this.error("Illegal control escape sequence");
    }

    private int o() {
        int n = this.read();
        if ((n - 48 | 55 - n) >= 0) {
            int n2 = this.read();
            if ((n2 - 48 | 55 - n2) >= 0) {
                int n3 = this.read();
                if ((n3 - 48 | 55 - n3) >= 0 && (n - 48 | 51 - n) >= 0) {
                    return (n - 48) * 64 + (n2 - 48) * 8 + (n3 - 48);
                }
                this.unread();
                return (n - 48) * 8 + (n2 - 48);
            }
            this.unread();
            return n - 48;
        }
        throw this.error("Illegal octal escape sequence");
    }

    private int x() {
        int n;
        int n2 = this.read();
        if (ASCII.isHexDigit(n2) && ASCII.isHexDigit(n = this.read())) {
            return ASCII.toDigit(n2) * 16 + ASCII.toDigit(n);
        }
        throw this.error("Illegal hexadecimal escape sequence");
    }

    private int u() {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = this.read();
            if (!ASCII.isHexDigit(n3)) {
                throw this.error("Illegal Unicode escape sequence");
            }
            n = n * 16 + ASCII.toDigit(n3);
            ++n2;
        }
        return n;
    }

    private static final boolean isSurrogate(int n) {
        return n >= 55296 && n <= 57343;
    }

    private static final int countChars(CharSequence charSequence, int n, int n2) {
        if (n2 == 1 && !Character.isHighSurrogate(charSequence.charAt(n))) {
            assert (n >= 0 && n < charSequence.length());
            return 1;
        }
        int n3 = charSequence.length();
        int n4 = n;
        if (n2 >= 0) {
            assert (n >= 0 && n < n3);
            int n5 = 0;
            while (n4 < n3 && n5 < n2) {
                if (Character.isHighSurrogate(charSequence.charAt(n4++)) && n4 < n3 && Character.isLowSurrogate(charSequence.charAt(n4))) {
                    ++n4;
                }
                ++n5;
            }
            return n4 - n;
        }
        assert (n >= 0 && n <= n3);
        if (n == 0) {
            return 0;
        }
        int n6 = -n2;
        int n7 = 0;
        while (n4 > 0 && n7 < n6) {
            if (Character.isLowSurrogate(charSequence.charAt(--n4)) && n4 > 0 && Character.isHighSurrogate(charSequence.charAt(n4 - 1))) {
                --n4;
            }
            ++n7;
        }
        return n - n4;
    }

    private static final int countCodePoints(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ++n2;
            if (!Character.isHighSurrogate(charSequence.charAt(n3++)) || n3 >= n || !Character.isLowSurrogate(charSequence.charAt(n3))) continue;
            ++n3;
        }
        return n2;
    }

    private CharProperty newSingle(int n) {
        if (this.has(2)) {
            int n2;
            int n3;
            if (this.has(64)) {
                int n4;
                int n5 = Character.toUpperCase(n);
                if (n5 != (n4 = Character.toLowerCase(n5))) {
                    return new SingleU(n4);
                }
            } else if (ASCII.isAscii(n) && (n3 = ASCII.toLower(n)) != (n2 = ASCII.toUpper(n))) {
                return new SingleI(n3, n2);
            }
        }
        if (PrimaryPattern.isSupplementary(n)) {
            return new SingleS(n);
        }
        return new Single(n);
    }

    private Node newSlice(int[] nArray, int n, boolean bl) {
        int[] nArray2 = new int[n];
        if (this.has(2)) {
            if (this.has(64)) {
                int n2 = 0;
                while (n2 < n) {
                    nArray2[n2] = Character.toLowerCase(Character.toUpperCase(nArray[n2]));
                    ++n2;
                }
                return bl ? new SliceUS(nArray2) : new SliceU(nArray2);
            }
            int n3 = 0;
            while (n3 < n) {
                nArray2[n3] = ASCII.toLower(nArray[n3]);
                ++n3;
            }
            return bl ? new SliceIS(nArray2) : new SliceI(nArray2);
        }
        int n4 = 0;
        while (n4 < n) {
            nArray2[n4] = nArray[n4];
            ++n4;
        }
        return bl ? new SliceS(nArray2) : new Slice(nArray2);
    }

    private static boolean inRange(int n, int n2, int n3) {
        return n <= n2 && n2 <= n3;
    }

    private static CharProperty rangeFor(final int n, final int n2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n3) {
                return PrimaryPattern.inRange(n, n3, n2);
            }
        };
    }

    private CharProperty caseInsensitiveRangeFor(final int n, final int n2) {
        if (this.has(64)) {
            return new CharProperty(){

                @Override
                boolean isSatisfiedBy(int n3) {
                    if (PrimaryPattern.inRange(n, n3, n2)) {
                        return true;
                    }
                    int n22 = Character.toUpperCase(n3);
                    return PrimaryPattern.inRange(n, n22, n2) || PrimaryPattern.inRange(n, Character.toLowerCase(n22), n2);
                }
            };
        }
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n3) {
                return PrimaryPattern.inRange(n, n3, n2) || ASCII.isAscii(n3) && (PrimaryPattern.inRange(n, ASCII.toUpper(n3), n2) || PrimaryPattern.inRange(n, ASCII.toLower(n3), n2));
            }
        };
    }

    private static CharProperty union(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n) {
                return charProperty.isSatisfiedBy(n) || charProperty2.isSatisfiedBy(n);
            }
        };
    }

    private static CharProperty intersection(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n) {
                return charProperty.isSatisfiedBy(n) && charProperty2.isSatisfiedBy(n);
            }
        };
    }

    private static CharProperty setDifference(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n) {
                return !charProperty2.isSatisfiedBy(n) && charProperty.isSatisfiedBy(n);
            }
        };
    }

    static final class All
    extends CharProperty {
        All() {
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return true;
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int n) {
            this.groupIndex = n + n;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }
    }

    static class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node node, int n, int n2) {
            this.cond = node;
            this.rmax = n;
            this.rmin = n2;
        }
    }

    static final class BehindS
    extends Behind {
        BehindS(Node node, int n, int n2) {
            super(node, n, n2);
        }
    }

    private static final class BitClass
    extends BmpCharProperty {
        final boolean[] bits;

        BitClass() {
            this.bits = new boolean[256];
        }

        private BitClass(boolean[] blArray) {
            this.bits = blArray;
        }

        BitClass add(int n, int n2) {
            assert (n >= 0 && n <= 255);
            if ((n2 & 2) != 0) {
                if (ASCII.isAscii(n)) {
                    this.bits[ASCII.toUpper((int)n)] = true;
                    this.bits[ASCII.toLower((int)n)] = true;
                } else if ((n2 & 0x40) != 0) {
                    this.bits[Character.toLowerCase((int)n)] = true;
                    this.bits[Character.toUpperCase((int)n)] = true;
                }
            }
            this.bits[n] = true;
            return this;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n < 256 && this.bits[n];
        }
    }

    private static abstract class BmpCharProperty
    extends CharProperty {
        private BmpCharProperty() {
        }
    }

    static class BnM
    extends Node {
        int[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            if (!(node instanceof Slice)) {
                return node;
            }
            int[] nArray = ((Slice)node).buffer;
            int n = nArray.length;
            if (n < 4) {
                return node;
            }
            int[] nArray2 = new int[128];
            int[] nArray3 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray2[nArray[n2] & 0x7F] = n2 + 1;
                ++n2;
            }
            n2 = n;
            while (n2 > 0) {
                block8: {
                    int n3 = n - 1;
                    while (n3 >= n2) {
                        if (nArray[n3] == nArray[n3 - n2]) {
                            nArray3[n3 - 1] = n2;
                            --n3;
                            continue;
                        }
                        break block8;
                    }
                    while (n3 > 0) {
                        nArray3[--n3] = n2;
                    }
                }
                --n2;
            }
            nArray3[n - 1] = 1;
            if (node instanceof SliceS) {
                return new BnMS(nArray, nArray2, nArray3, node.next);
            }
            return new BnM(nArray, nArray2, nArray3, node.next);
        }

        BnM(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            this.buffer = nArray;
            this.lastOcc = nArray2;
            this.optoSft = nArray3;
            this.next = node;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class BnMS
    extends BnM {
        int lengthInChars;

        BnMS(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            super(nArray, nArray2, nArray3, node);
            int n = 0;
            while (n < this.buffer.length) {
                this.lengthInChars += Character.charCount(this.buffer[n]);
                ++n;
            }
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;

        Bound(int n) {
            this.type = n;
        }
    }

    static final class Branch
    extends Node {
        Node[] atoms = new Node[2];
        int size = 2;
        Node conn;

        Branch(Node node, Node node2, Node node3) {
            this.conn = node3;
            this.atoms[0] = node;
            this.atoms[1] = node2;
        }

        void add(Node node) {
            if (this.size >= this.atoms.length) {
                Node[] nodeArray = new Node[this.atoms.length * 2];
                System.arraycopy(this.atoms, 0, nodeArray, 0, this.atoms.length);
                this.atoms = nodeArray;
            }
            this.atoms[this.size++] = node;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            int n3 = Integer.MAX_VALUE;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.size) {
                treeInfo.reset();
                if (this.atoms[n5] != null) {
                    this.atoms[n5].study(treeInfo);
                }
                n3 = Math.min(n3, treeInfo.minLength);
                n4 = Math.max(n4, treeInfo.maxLength);
                bl &= treeInfo.maxValid;
                ++n5;
            }
            treeInfo.reset();
            this.conn.next.study(treeInfo);
            treeInfo.minLength += (n += n3);
            treeInfo.maxLength += (n2 += n4);
            treeInfo.maxValid &= bl;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class BranchConn
    extends Node {
        BranchConn() {
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            return treeInfo.deterministic;
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;
        boolean doUnicodeCase;

        CIBackRef(int n, boolean bl) {
            this.groupIndex = n + n;
            this.doUnicodeCase = bl;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }
    }

    static final class Category
    extends CharProperty {
        final int typeMask;

        Category(int n) {
            this.typeMask = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return (this.typeMask & 1 << Character.getType(n)) != 0;
        }
    }

    private static abstract class CharProperty
    extends Node {
        private CharProperty() {
        }

        abstract boolean isSatisfiedBy(int var1);

        CharProperty complement() {
            return new CharProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return !CharProperty.this.isSatisfiedBy(n);
                }
            };
        }

        CharProperty maybeComplement(boolean bl) {
            return bl ? this.complement() : this;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    private static class CharPropertyNames {
        private static final HashMap<String, CharPropertyFactory> map = new HashMap();

        static {
            CharPropertyNames.defCategory("Cn", 1);
            CharPropertyNames.defCategory("Lu", 2);
            CharPropertyNames.defCategory("Ll", 4);
            CharPropertyNames.defCategory("Lt", 8);
            CharPropertyNames.defCategory("Lm", 16);
            CharPropertyNames.defCategory("Lo", 32);
            CharPropertyNames.defCategory("Mn", 64);
            CharPropertyNames.defCategory("Me", 128);
            CharPropertyNames.defCategory("Mc", 256);
            CharPropertyNames.defCategory("Nd", 512);
            CharPropertyNames.defCategory("Nl", 1024);
            CharPropertyNames.defCategory("No", 2048);
            CharPropertyNames.defCategory("Zs", 4096);
            CharPropertyNames.defCategory("Zl", 8192);
            CharPropertyNames.defCategory("Zp", 16384);
            CharPropertyNames.defCategory("Cc", 32768);
            CharPropertyNames.defCategory("Cf", 65536);
            CharPropertyNames.defCategory("Co", 262144);
            CharPropertyNames.defCategory("Cs", 524288);
            CharPropertyNames.defCategory("Pd", 0x100000);
            CharPropertyNames.defCategory("Ps", 0x200000);
            CharPropertyNames.defCategory("Pe", 0x400000);
            CharPropertyNames.defCategory("Pc", 0x800000);
            CharPropertyNames.defCategory("Po", 0x1000000);
            CharPropertyNames.defCategory("Sm", 0x2000000);
            CharPropertyNames.defCategory("Sc", 0x4000000);
            CharPropertyNames.defCategory("Sk", 0x8000000);
            CharPropertyNames.defCategory("So", 0x10000000);
            CharPropertyNames.defCategory("Pi", 0x20000000);
            CharPropertyNames.defCategory("Pf", 0x40000000);
            CharPropertyNames.defCategory("L", 62);
            CharPropertyNames.defCategory("M", 448);
            CharPropertyNames.defCategory("N", 3584);
            CharPropertyNames.defCategory("Z", 28672);
            CharPropertyNames.defCategory("C", 884736);
            CharPropertyNames.defCategory("P", 1643118592);
            CharPropertyNames.defCategory("S", 0x1E000000);
            CharPropertyNames.defCategory("LC", 14);
            CharPropertyNames.defCategory("LD", 574);
            CharPropertyNames.defRange("L1", 0, 255);
            map.put("all", new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return new All();
                }
            });
            CharPropertyNames.defRange("ASCII", 0, 127);
            CharPropertyNames.defCtype("Alnum", 1792);
            CharPropertyNames.defCtype("Alpha", 768);
            CharPropertyNames.defCtype("Blank", 16384);
            CharPropertyNames.defCtype("Cntrl", 8192);
            CharPropertyNames.defRange("Digit", 48, 57);
            CharPropertyNames.defCtype("Graph", 5888);
            CharPropertyNames.defRange("Lower", 97, 122);
            CharPropertyNames.defRange("Print", 32, 126);
            CharPropertyNames.defCtype("Punct", 4096);
            CharPropertyNames.defCtype("Space", 2048);
            CharPropertyNames.defRange("Upper", 65, 90);
            CharPropertyNames.defCtype("XDigit", 32768);
            CharPropertyNames.defClone("javaLowerCase", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isLowerCase(n);
                }
            });
            CharPropertyNames.defClone("javaUpperCase", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isUpperCase(n);
                }
            });
            CharPropertyNames.defClone("javaTitleCase", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isTitleCase(n);
                }
            });
            CharPropertyNames.defClone("javaDigit", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isDigit(n);
                }
            });
            CharPropertyNames.defClone("javaDefined", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isDefined(n);
                }
            });
            CharPropertyNames.defClone("javaLetter", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isLetter(n);
                }
            });
            CharPropertyNames.defClone("javaLetterOrDigit", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isLetterOrDigit(n);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierStart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isJavaIdentifierStart(n);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierPart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isJavaIdentifierPart(n);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierStart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isUnicodeIdentifierStart(n);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierPart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isUnicodeIdentifierPart(n);
                }
            });
            CharPropertyNames.defClone("javaIdentifierIgnorable", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isIdentifierIgnorable(n);
                }
            });
            CharPropertyNames.defClone("javaSpaceChar", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isSpaceChar(n);
                }
            });
            CharPropertyNames.defClone("javaWhitespace", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isWhitespace(n);
                }
            });
            CharPropertyNames.defClone("javaISOControl", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isISOControl(n);
                }
            });
            CharPropertyNames.defClone("javaMirrored", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isMirrored(n);
                }
            });
        }

        private CharPropertyNames() {
        }

        static CharProperty charPropertyFor(String string) {
            CharPropertyFactory charPropertyFactory = map.get(string);
            return charPropertyFactory == null ? null : charPropertyFactory.make();
        }

        private static void defCategory(String string, final int n) {
            map.put(string, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return new Category(n);
                }
            });
        }

        private static void defRange(String string, final int n, final int n2) {
            map.put(string, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return PrimaryPattern.rangeFor(n, n2);
                }
            });
        }

        private static void defCtype(String string, final int n) {
            map.put(string, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return new Ctype(n);
                }
            });
        }

        private static void defClone(String string, final CloneableProperty cloneableProperty) {
            map.put(string, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return cloneableProperty.clone();
                }
            });
        }

        private static abstract class CharPropertyFactory {
            private CharPropertyFactory() {
            }

            abstract CharProperty make();
        }

        private static abstract class CloneableProperty
        extends CharProperty
        implements Cloneable {
            private CloneableProperty() {
            }

            public CloneableProperty clone() {
                try {
                    return (CloneableProperty)super.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new AssertionError((Object)cloneNotSupportedException);
                }
            }
        }
    }

    static final class Ctype
    extends BmpCharProperty {
        final int ctype;

        Ctype(int n) {
            this.ctype = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n < 128 && ASCII.isType(n, this.ctype);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", ctype=" + this.ctype;
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;

        Curly(Node node, int n, int n2, int n3) {
            this.atom = node;
            this.type = n3;
            this.cmin = n;
            this.cmax = n2;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n3 = treeInfo.minLength * this.cmin + n;
            if (n3 < n) {
                n3 = 0xFFFFFFF;
            }
            treeInfo.minLength = n3;
            if (bl & treeInfo.maxValid) {
                treeInfo.maxLength = n3 = treeInfo.maxLength * this.cmax + n2;
                if (n3 < n2) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl2 : false;
            return this.next.study(treeInfo);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", atom=" + this.atom + ", type=" + this.type + ", cmin=" + this.cmin + ", cmax=" + this.cmax;
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean bl) {
            this.multiline = bl;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class Dot
    extends CharProperty {
        Dot() {
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n != 10 && n != 13 && (n | 1) != 8233 && n != 133;
        }
    }

    static final class End
    extends Node {
        End() {
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.atom.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;
        boolean capture;

        GroupCurly(Node node, int n, int n2, int n3, int n4, int n5, boolean bl) {
            this.atom = node;
            this.type = n3;
            this.cmin = n;
            this.cmax = n2;
            this.localIndex = n4;
            this.groupIndex = n5;
            this.capture = bl;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n3 = treeInfo.minLength * this.cmin + n;
            if (n3 < n) {
                n3 = 0xFFFFFFF;
            }
            treeInfo.minLength = n3;
            if (bl & treeInfo.maxValid) {
                treeInfo.maxLength = n3 = treeInfo.maxLength * this.cmax + n2;
                if (n3 < n2) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl2 : false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;
        final int groupIndex;
        final int position;

        GroupHead(boolean bl, int n, int n2, int n3) {
            this.localIndex = n;
            this.groupIndex = bl ? -1 : n2;
            this.position = n3;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " localIndex=" + this.localIndex + ", groupIndex=" + this.groupIndex + ", pos=" + this.position;
        }
    }

    static final class GroupTail
    extends Node {
        final int localIndex;
        final int groupIndex;
        private int position = -1;

        GroupTail(boolean bl, int n, int n2) {
            this.localIndex = n;
            this.groupIndex = bl ? -1 : n2;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", localIndex=" + this.localIndex + ", groupIndex=" + this.groupIndex + ", pos=" + this.position;
        }

        private void setPosition(int n) {
            assert (n >= 0);
            if (this.position >= 0) {
                LOG.error("Already set pos " + this.position);
            }
            this.position = n;
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int n, int n2) {
            super(n, n2);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;

        Loop(int n, int n2) {
            this.countIndex = n;
            this.beginIndex = n2;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node node) {
            this.cond = node;
        }
    }

    static class Node {
        Node next = accept;

        Node() {
        }

        boolean study(TreeInfo treeInfo) {
            if (this.next != null) {
                return this.next.study(treeInfo);
            }
            return treeInfo.deterministic;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node node, int n, int n2) {
            this.cond = node;
            this.rmax = n;
            this.rmin = n2;
        }
    }

    static final class NotBehindS
    extends NotBehind {
        NotBehindS(Node node, int n, int n2) {
            super(node, n, n2);
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node node) {
            this.cond = node;
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            return this.loop.study(treeInfo);
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        int type;

        Ques(Node node, int n) {
            this.atom = node;
            this.type = n;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            if (this.type != 3) {
                int n = treeInfo.minLength;
                this.atom.study(treeInfo);
                treeInfo.minLength = n;
                treeInfo.deterministic = false;
                return this.next.study(treeInfo);
            }
            this.atom.study(treeInfo);
            return this.next.study(treeInfo);
        }
    }

    static final class Single
    extends BmpCharProperty {
        final int c;

        Single(int n) {
            this.c = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n == this.c;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " char=" + (this.c >= 32 && this.c <= 127 ? (int)this.c : this.c);
        }
    }

    static final class SingleI
    extends BmpCharProperty {
        final int lower;
        final int upper;

        SingleI(int n, int n2) {
            this.lower = n;
            this.upper = n2;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n == this.lower || n == this.upper;
        }
    }

    static final class SingleS
    extends CharProperty {
        final int c;

        SingleS(int n) {
            this.c = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n == this.c;
        }
    }

    static final class SingleU
    extends CharProperty {
        final int lower;

        SingleU(int n) {
            this.lower = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return this.lower == n || this.lower == Character.toLowerCase(Character.toUpperCase(n));
        }
    }

    static final class Slice
    extends SliceNode {
        Slice(int[] nArray) {
            super(nArray);
        }
    }

    static class SliceI
    extends SliceNode {
        SliceI(int[] nArray) {
            super(nArray);
        }
    }

    static class SliceIS
    extends SliceNode {
        SliceIS(int[] nArray) {
            super(nArray);
        }

        int toLower(int n) {
            return ASCII.toLower(n);
        }
    }

    static class SliceNode
    extends Node {
        int[] buffer;

        SliceNode(int[] nArray) {
            this.buffer = nArray;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " buffer=" + Arrays.toString(this.buffer);
        }
    }

    static final class SliceS
    extends SliceNode {
        SliceS(int[] nArray) {
            super(nArray);
        }
    }

    static final class SliceU
    extends SliceNode {
        SliceU(int[] nArray) {
            super(nArray);
        }
    }

    static final class SliceUS
    extends SliceIS {
        SliceUS(int[] nArray) {
            super(nArray);
        }

        @Override
        int toLower(int n) {
            return Character.toLowerCase(Character.toUpperCase(n));
        }
    }

    static class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo treeInfo = new TreeInfo();
            this.next.study(treeInfo);
            this.minLength = treeInfo.minLength;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class StartS
    extends Start {
        StartS(Node node) {
            super(node);
        }
    }

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }

        public String toString() {
            return "minLength=" + this.minLength + ", maxLength=" + this.maxLength + ", maxValid=" + this.maxValid + ", deterministic=" + this.deterministic;
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean bl) {
            this.multiline = bl;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class UnixDot
    extends CharProperty {
        UnixDot() {
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n != 10;
        }
    }
}

