/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.regex;

import com.deltopia.regex.Node;

final class GroupNode
extends Node {
    private final int groupIndex;

    GroupNode(int n, int n2) throws IllegalArgumentException {
        super(n);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid group index " + n2);
        }
        this.groupIndex = n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        GroupNode groupNode = (GroupNode)object;
        return this.groupIndex == groupNode.groupIndex;
    }

    public int groupIndex() {
        return this.groupIndex;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.groupIndex;
        return n;
    }

    @Override
    public String toString() {
        return "Reference group=" + this.groupIndex + " " + super.toString();
    }
}

