/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.regex;

import com.deltopia.regex.GroupNode;
import com.deltopia.regex.Node;
import com.deltopia.regex.PrimaryPattern;
import com.deltopia.regex.SecondaryPatternParser;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DualPattern {
    private static final Logger LOG = LoggerFactory.getLogger(DualPattern.class);
    private final int flags;
    private final int maxGroupIndex;
    private final List<Node> nodes;
    private final Pattern primaryPattern;
    private final Pattern secondaryPattern;
    private final String secondaryRegex;

    public static final DualPattern compile(String string, String string2, int n) throws PatternSyntaxException {
        Pattern pattern = Pattern.compile(string, n);
        PrimaryPattern primaryPattern = PrimaryPattern.compile(string, n);
        if (LOG.isInfoEnabled()) {
            LOG.info("Compile Primary regex '" + string + "':\n\t" + primaryPattern);
        }
        int n2 = primaryPattern.getGroupCount();
        SecondaryPatternParser secondaryPatternParser = new SecondaryPatternParser(string2, primaryPattern);
        secondaryPatternParser.parse();
        if (LOG.isInfoEnabled()) {
            LOG.info("Compile Secondary regex '" + string2 + "':\n\t" + secondaryPatternParser);
        }
        Pattern pattern2 = Pattern.compile(secondaryPatternParser.normalizedRegex(), n);
        int n3 = secondaryPatternParser.getMaxGroupIndex();
        if (n3 >= 0 && n2 < n3) {
            throw new PatternSyntaxException("Invalid number of groups" + n2 + "<" + n3 + ". " + "primary: '" + string + "', secondary: '" + string2, string, -1);
        }
        if (pattern.pattern().equals(pattern2.pattern()) && pattern.flags() == pattern2.flags()) {
            throw new PatternSyntaxException("Patterns are equals", "'" + pattern + "' '" + pattern2 + '\'', -1);
        }
        DualPattern dualPattern = new DualPattern(pattern, string2, pattern2, n, secondaryPatternParser.nodes(), n3);
        if (LOG.isInfoEnabled()) {
            LOG.info("Creates dual pattern: " + dualPattern);
        }
        return dualPattern;
    }

    private DualPattern(Pattern pattern, String string, Pattern pattern2, int n, List<Node> list, int n2) {
        assert (pattern != null);
        assert (string != null);
        assert (pattern2 != null);
        assert (list != null);
        this.flags = n;
        this.primaryPattern = pattern;
        this.secondaryRegex = string;
        this.secondaryPattern = pattern2;
        this.nodes = Collections.unmodifiableList(list);
        this.maxGroupIndex = n2;
    }

    private boolean hasFlags(int n) {
        return n == (this.flags & n);
    }

    public boolean matches(String string, String string2) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("str1");
        }
        if (string2 == null) {
            throw new NullPointerException("str2");
        }
        Matcher matcher = this.primaryPattern.matcher(string);
        boolean bl = false;
        if (matcher.matches()) {
            Matcher matcher2 = this.secondaryPattern.matcher(string2);
            if (matcher2.matches()) {
                int n = matcher.groupCount();
                if (n < this.maxGroupIndex) {
                    throw new IllegalStateException("Invalid number of groups" + n + "<" + this.maxGroupIndex + ". " + this);
                }
                boolean bl2 = this.hasFlags(2);
                for (Node node : this.nodes) {
                    if (node instanceof GroupNode) {
                        GroupNode groupNode = (GroupNode)node;
                        int n2 = groupNode.groupIndex();
                        String string3 = matcher.group(n2);
                        String string4 = matcher2.group(n2);
                        bl = bl2 ? string3.equalsIgnoreCase(string4) : string3.equals(string4);
                        if (bl) continue;
                        break;
                    }
                    throw new IllegalStateException();
                }
                if (LOG.isInfoEnabled()) {
                    if (bl) {
                        LOG.info("Matches: " + string + "/" + string2 + "\n\t " + this);
                    } else {
                        LOG.info("No matches for groups: " + string + "/" + string2 + "\n\t " + this);
                    }
                }
            } else if (LOG.isInfoEnabled()) {
                LOG.info("No matches for 2: " + string + "/" + string2 + "\n\t " + this);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("No matches for 1: " + string + "/" + string2 + "\n\t " + this);
        }
        return bl;
    }

    public String primaryRegex() {
        return this.primaryPattern.pattern();
    }

    public String secondaryRegex() {
        return this.secondaryRegex;
    }

    public String toString() {
        return "primary: '" + this.primaryPattern + "', secondary: '" + this.secondaryPattern + "' [" + this.secondaryRegex + ']';
    }
}

