/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.net;

import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;

public class ProgressFileRequestEntity
implements RequestEntity {
    protected final String contentType;
    protected final File file;
    protected final ISyncProgressMonitor pm;

    public ProgressFileRequestEntity(File file, String string, ISyncProgressMonitor iSyncProgressMonitor) throws NullPointerException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
        this.contentType = string;
        this.pm = iSyncProgressMonitor;
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void writeRequest(OutputStream outputStream) throws IOException {
        assert (outputStream != null);
        FileInputStream fileInputStream = new FileInputStream(this.file);
        try {
            StreamUtil.copyStream(fileInputStream, outputStream, 32768, this.pm);
        }
        finally {
            StreamUtil.closeSilently(fileInputStream);
        }
    }
}

