/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.net;

import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.FilePart;

public class ProgressFilePart
extends FilePart {
    private final File file;
    private final ISyncProgressMonitor pm;

    public ProgressFilePart(File file, String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) throws NullPointerException, FileNotFoundException {
        super(file.getName(), file, string, string2);
        this.file = file;
        this.pm = iSyncProgressMonitor;
    }

    @Override
    protected void sendData(OutputStream outputStream) throws IOException {
        if (this.lengthOfData() == 0L) {
            throw new IOException("Try to upload empty file");
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        try {
            StreamUtil.copyStream(fileInputStream, outputStream, 32768, this.pm);
        }
        finally {
            StreamUtil.closeSilently(fileInputStream);
        }
    }
}

