/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.net;

import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.ZipCompressor;
import com.deltopia.net.ProgressFilePart;
import com.deltopia.net.ProgressFileRequestEntity;
import com.deltopia.util.logging.LogUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSubmitter {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSubmitter.class);
    private static final FileFilter FILTER = new Filter();
    private static final int CONNECT_TIMEOUT = 20000;
    private static final int READ_TIMEOUT = 60000;

    private static final void executeMethod(PostMethod postMethod) throws IOException {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(20000);
        int n = httpClient.executeMethod(postMethod);
        if (n == 200) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Finish Completed " + postMethod + ", response: " + postMethod.getResponseBodyAsString());
            }
        } else {
            String string = postMethod.getStatusText();
            if (string == null || string.length() <= 0) {
                string = HttpStatus.getStatusText(n);
            }
            string = "Server return error: " + n + (string != null ? " " + string : "");
            LOG.warn("Finish Failed " + postMethod + ", msg: " + string + ", body:\n" + postMethod.getResponseBodyAsString());
            throw new IOException(string);
        }
    }

    public static final void postRequest(URL uRL, Map<String, String> map) throws NullPointerException, IllegalArgumentException, IOException {
        if (uRL == null) {
            throw new NullPointerException("url");
        }
        if (map == null) {
            throw new NullPointerException("params");
        }
        String string = uRL.getProtocol();
        if (!string.equals("http") && !string.equals("https")) {
            throw new IllegalArgumentException("Unsupported protocol " + uRL);
        }
        PostMethod postMethod = new PostMethod(uRL.toExternalForm());
        try {
            HttpMethodParams httpMethodParams = postMethod.getParams();
            httpMethodParams.setBooleanParameter("http.protocol.expect-continue", false);
            httpMethodParams.setSoTimeout(60000);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) {
                    throw new IllegalArgumentException("Null params " + map);
                }
                postMethod.setParameter(entry.getKey(), entry.getValue());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Start registration posting " + uRL);
            }
            HttpSubmitter.executeMethod(postMethod);
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    public static final void submitDWMetaFiles(URL uRL, String string, ISyncProgressMonitor iSyncProgressMonitor, boolean bl) throws IOException {
        HttpSubmitter.submitFiles(Collections.singleton(LogUtil.getLogDirectory()), uRL, string, iSyncProgressMonitor, bl);
    }

    public static final void submitFiles(Set<File> set, URL uRL, String string, ISyncProgressMonitor iSyncProgressMonitor, boolean bl) throws IOException {
        if (set == null) {
            throw new NullPointerException("inList");
        }
        if (uRL == null) {
            throw new NullPointerException("outFile");
        }
        if (!uRL.getProtocol().startsWith("http")) {
            throw new IllegalArgumentException("unsupported protocol: " + uRL);
        }
        File file = File.createTempFile("DWReport_", ".zip");
        try {
            File file2 = null;
            try {
                Object object;
                LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(set);
                if (string != null && string.length() > 0) {
                    file2 = File.createTempFile("UserMessage_", ".txt");
                    object = new FileOutputStream(file2);
                    try {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, "UTF-8");
                        try {
                            outputStreamWriter.write(string);
                        }
                        finally {
                            StreamUtil.closeSilently(outputStreamWriter);
                        }
                    }
                    finally {
                        StreamUtil.closeSilently((Closeable)object);
                    }
                    linkedHashSet.add(file2);
                }
                if (linkedHashSet.isEmpty()) {
                    throw new IllegalArgumentException("Empty list");
                }
                object = new ZipCompressor();
                ((ZipCompressor)object).setFilter(FILTER);
                ((ZipCompressor)object).setStrict(false);
                ((ZipCompressor)object).setMaxLevel(1);
                ((ZipCompressor)object).compressPaths(linkedHashSet, file, iSyncProgressMonitor);
                if (file.length() <= 0L) {
                    throw new IOException(" Cannot create valid archive from inout list");
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("Compress " + linkedHashSet.size() + " items to " + file);
                }
            }
            finally {
                if (!file2.delete() && file2.exists()) {
                    LOG.warn("Cannot delete file " + file2);
                    file2.deleteOnExit();
                }
            }
            HttpSubmitter.uploadFile(file, "application/zip", uRL, iSyncProgressMonitor, bl);
        }
        finally {
            if (!file.delete() && file.exists()) {
                LOG.warn("Cannot delete " + file);
                file.deleteOnExit();
            }
        }
    }

    static final void uploadFile(File file, String string, URL uRL, ISyncProgressMonitor iSyncProgressMonitor, boolean bl) throws NullPointerException, IOException {
        PostMethod postMethod = new PostMethod(uRL.toExternalForm());
        try {
            HttpMethodParams httpMethodParams = postMethod.getParams();
            httpMethodParams.setBooleanParameter("http.protocol.expect-continue", false);
            httpMethodParams.setSoTimeout(60000);
            if (LOG.isInfoEnabled()) {
                LOG.info("Start Uploading " + file + " -> " + uRL);
            }
            if (bl) {
                Part[] partArray = new Part[]{new ProgressFilePart(file, string, null, iSyncProgressMonitor)};
                postMethod.setRequestEntity(new MultipartRequestEntity(partArray, postMethod.getParams()));
            } else {
                postMethod.setRequestEntity(new ProgressFileRequestEntity(file, string, iSyncProgressMonitor));
            }
            HttpSubmitter.executeMethod(postMethod);
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    private static final class Filter
    implements FileFilter {
        private Filter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return !string.contains("lck");
        }
    }
}

