/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io.xml;

import com.deltopia.StringUtil;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlWriter {
    private static final SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
    private final AttributesImpl atCache = new AttributesImpl();
    private final TransformerHandler transformerHandler;

    public XmlWriter(Writer writer, boolean bl, int n) {
        Object object;
        try {
            this.transformerHandler = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IllegalStateException(transformerConfigurationException);
        }
        Transformer transformer = this.transformerHandler.getTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        if (n > 0) {
            transformer.setOutputProperty("indent", "yes");
            object = String.valueOf(n);
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", (String)object);
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", (String)object);
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        transformer.setOutputProperty("omit-xml-declaration", bl ? "no" : "yes");
        object = new StreamResult(writer);
        this.transformerHandler.setResult((Result)object);
    }

    public void addElement(String string, String string2) throws SAXException {
        this.startElement(string);
        this.characters(string2);
        this.endElement(string);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.transformerHandler.characters(cArray, n, n2);
    }

    public void characters(String string) throws SAXException {
        char[] cArray = StringUtil.makeSafe(string).toCharArray();
        this.transformerHandler.characters(cArray, 0, cArray.length);
    }

    public void emptyElement(String string, Attributes attributes) throws SAXException {
        this.emptyElement(null, null, string, attributes);
    }

    public void emptyElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.startElement(string, string2, string3, attributes);
        this.endElement(string, string2, string3);
    }

    public void emptyElementAttr(String string, String string2, String string3) throws SAXException {
        this.atCache.clear();
        this.atCache.addAttribute(null, null, string2, "CDATA", string3);
        this.emptyElement(null, null, string, this.atCache);
    }

    public void emptyElementAttr(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.atCache.clear();
        this.atCache.addAttribute(null, null, string2, "CDATA", string3);
        this.atCache.addAttribute(null, null, string4, "CDATA", string5);
        this.emptyElement(null, null, string, this.atCache);
    }

    public void endDocument() throws SAXException {
        this.transformerHandler.endDocument();
    }

    public void endElement(String string) throws SAXException {
        this.transformerHandler.endElement(null, null, string);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.transformerHandler.endElement(string, string2, string3);
    }

    public void setDocumentLocator(Locator locator) {
        this.transformerHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.transformerHandler.startDocument();
    }

    public void startElement(String string) throws SAXException {
        this.startElement(null, null, string, null);
    }

    public void startElement(String string, Attributes attributes) throws SAXException {
        this.startElement(null, null, string, attributes);
    }

    public void startElement(String string, String string2, String string3) throws SAXException {
        this.startElement(string, string2, string3, null);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.transformerHandler.startElement(string, string2, string3, attributes);
    }

    public void startElementAttr(String string, String string2, String string3) throws SAXException {
        this.atCache.clear();
        this.atCache.addAttribute(null, null, string2, "CDATA", string3);
        this.startElement(null, null, string, this.atCache);
    }

    public void startElementAttr(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.atCache.clear();
        this.atCache.addAttribute(null, null, string2, "CDATA", string3);
        this.atCache.addAttribute(null, null, string4, "CDATA", string5);
        this.startElement(null, null, string, this.atCache);
    }

    public void startElementAttr(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SAXException {
        this.atCache.clear();
        this.atCache.addAttribute(null, null, string2, "CDATA", string3);
        this.atCache.addAttribute(null, null, string4, "CDATA", string5);
        this.atCache.addAttribute(null, null, string6, "CDATA", string7);
        this.startElement(null, null, string, this.atCache);
    }

    public void textElement(String string, String string2, String string3, String string4) throws SAXException {
        this.startElementAttr(string, string2, string3);
        this.characters(string4);
        this.transformerHandler.endElement(null, null, string);
    }

    public void textElement(String string, String string2) throws SAXException {
        this.textElement(string, string2, null);
    }

    public void textElement(String string, String string2, Attributes attributes) throws SAXException {
        this.transformerHandler.startElement(null, null, string, attributes);
        this.characters(string2);
        this.transformerHandler.endElement(null, null, string);
    }
}

