/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.ValidityException;
import nu.xom.canonical.Canonicalizer;

public class XmlTransformer {
    private static String canonicalize(Document document) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Canonicalizer canonicalizer = new Canonicalizer((OutputStream)byteArrayOutputStream);
        canonicalizer.write((Node)document);
        return byteArrayOutputStream.toString("UTF-8");
    }

    private static String prettify(Document document) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Serializer serializer = new Serializer((OutputStream)byteArrayOutputStream);
        serializer.setIndent(2);
        serializer.setPreserveBaseURI(true);
        serializer.write(document);
        serializer.flush();
        return byteArrayOutputStream.toString("UTF-8");
    }

    public static String transform(String string, Op op) throws ValidityException, ParsingException, IOException {
        Builder builder = new Builder();
        Document document = builder.build(string, null);
        if (op == Op.CANONICALIZE) {
            return XmlTransformer.canonicalize(document);
        }
        return XmlTransformer.prettify(document);
    }

    private XmlTransformer() {
    }

    public static enum Op {
        CANONICALIZE,
        PRETTIFY;

    }
}

