/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io.json;

import com.deltopia.io.json.JsonArray;
import com.deltopia.io.json.JsonException;
import com.deltopia.io.json.JsonString;
import com.deltopia.io.json.JsonTokener;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JsonObject {
    private Hashtable myHashMap;
    public static final Object NULL = new Null();

    public JsonObject() {
        this.myHashMap = new Hashtable();
    }

    public JsonObject(JsonObject jsonObject, String[] stringArray) throws JsonException {
        this();
        int n = 0;
        while (n < stringArray.length) {
            this.putOpt(stringArray[n], jsonObject.opt(stringArray[n]));
            ++n;
        }
    }

    public JsonObject(JsonTokener jsonTokener) throws JsonException {
        this();
        if (jsonTokener.nextClean() != '{') {
            throw jsonTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = jsonTokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw jsonTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jsonTokener.back();
            String string = jsonTokener.nextValue().toString();
            c = jsonTokener.nextClean();
            if (c == '=') {
                if (jsonTokener.next() != '>') {
                    jsonTokener.back();
                }
            } else if (c != ':') {
                throw jsonTokener.syntaxError("Expected a ':' after a key");
            }
            this.put(string, jsonTokener.nextValue());
            switch (jsonTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jsonTokener.nextClean() == '}') {
                        return;
                    }
                    jsonTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jsonTokener.syntaxError("Expected a ',' or '}'");
    }

    public JsonObject(Hashtable hashtable) {
        if (hashtable == null) {
            this.myHashMap = new Hashtable();
        } else {
            this.myHashMap = new Hashtable(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                this.myHashMap.put(k, hashtable.get(k));
            }
        }
    }

    public JsonObject(String string) throws JsonException {
        this(new JsonTokener(string));
    }

    public JsonObject accumulate(String string, Object object) throws JsonException {
        JsonObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, object);
        } else if (object2 instanceof JsonArray) {
            ((JsonArray)object2).put(object);
        } else {
            this.put(string, new JsonArray().put(object2).put(object));
        }
        return this;
    }

    public JsonObject append(String string, Object object) throws JsonException {
        JsonObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, new JsonArray().put(object));
        } else {
            if (object2 instanceof JsonArray) {
                throw new JsonException("JSONObject[" + string + "] is not a JSONArray.");
            }
            this.put(string, new JsonArray().put(object2).put(object));
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object get(String string) throws JsonException {
        Object object = this.opt(string);
        if (object == null) {
            throw new JsonException("JSONObject[" + JsonObject.quote(string) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String string) throws JsonException {
        Object object = this.get(string);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JsonException("JSONObject[" + JsonObject.quote(string) + "] is not a Boolean.");
    }

    public double getDouble(String string) throws JsonException {
        Object object = this.get(string);
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return ((Long)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (Exception exception) {
                throw new JsonException("JSONObject[" + JsonObject.quote(string) + "] is not a number.");
            }
        }
        throw new JsonException("JSONObject[" + JsonObject.quote(string) + "] is not a number.");
    }

    public int getInt(String string) throws JsonException {
        Object object = this.get(string);
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        if (object instanceof Float) {
            return (int)((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (int)((Double)object).doubleValue();
        }
        if (object instanceof String) {
            return (int)this.getDouble(string);
        }
        throw new JsonException("JSONObject[" + JsonObject.quote(string) + "] is not a number.");
    }

    public JsonArray getJsonArray(String string) throws JsonException {
        Object object = this.get(string);
        if (object instanceof JsonArray) {
            return (JsonArray)object;
        }
        throw new JsonException("JSONObject[" + JsonObject.quote(string) + "] is not a JSONArray.");
    }

    public JsonObject getJsonObject(String string) throws JsonException {
        Object object = this.get(string);
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        throw new JsonException("JSONObject[" + JsonObject.quote(string) + "] is not a JSONObject.");
    }

    public long getLong(String string) throws JsonException {
        Object object = this.get(string);
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Float) {
            return (long)((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (long)((Double)object).doubleValue();
        }
        if (object instanceof String) {
            return (long)this.getDouble(string);
        }
        throw new JsonException("JSONObject[" + JsonObject.quote(string) + "] is not a number.");
    }

    public String getString(String string) throws JsonException {
        return this.get(string).toString();
    }

    public boolean has(String string) {
        return this.myHashMap.containsKey(string);
    }

    public boolean isNull(String string) {
        return NULL.equals(this.opt(string));
    }

    public Enumeration keys() {
        return this.myHashMap.keys();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public JsonArray names() {
        JsonArray jsonArray = new JsonArray();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            jsonArray.put(enumeration.nextElement());
        }
        return jsonArray.length() == 0 ? null : jsonArray;
    }

    public static String trimNumber(String string) {
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String numberToString(Object object) throws JsonException {
        if (object == null) {
            throw new JsonException("Null pointer");
        }
        JsonObject.testValidity(object);
        return JsonObject.trimNumber(object.toString());
    }

    public Object opt(String string) {
        return string == null ? null : this.myHashMap.get(string);
    }

    public boolean optBoolean(String string) {
        return this.optBoolean(string, false);
    }

    public boolean optBoolean(String string, boolean bl) {
        try {
            return this.getBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public JsonObject put(String string, Vector vector) throws JsonException {
        this.put(string, new JsonArray(vector));
        return this;
    }

    public double optDouble(String string) {
        return this.optDouble(string, Double.NaN);
    }

    public double optDouble(String string, double d) {
        try {
            Object object = this.opt(string);
            return Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public int optInt(String string) {
        return this.optInt(string, 0);
    }

    public int optInt(String string, int n) {
        try {
            return this.getInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public JsonArray optJSONArray(String string) {
        Object object = this.opt(string);
        return object instanceof JsonArray ? (JsonArray)object : null;
    }

    public JsonObject optJSONObject(String string) {
        Object object = this.opt(string);
        return object instanceof JsonObject ? (JsonObject)object : null;
    }

    public long optLong(String string) {
        return this.optLong(string, 0L);
    }

    public long optLong(String string, long l) {
        try {
            return this.getLong(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(String string) {
        return this.optString(string, "");
    }

    public String optString(String string, String string2) {
        Object object = this.opt(string);
        return object != null ? object.toString() : string2;
    }

    public JsonObject put(String string, boolean bl) throws JsonException {
        this.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonObject put(String string, double d) throws JsonException {
        this.put(string, new Double(d));
        return this;
    }

    public JsonObject put(String string, int n) throws JsonException {
        this.put(string, new Integer(n));
        return this;
    }

    public JsonObject put(String string, long l) throws JsonException {
        this.put(string, new Long(l));
        return this;
    }

    public JsonObject put(String string, Hashtable hashtable) throws JsonException {
        this.put(string, new JsonObject(hashtable));
        return this;
    }

    public JsonObject put(String string, Object object) throws JsonException {
        if (string == null) {
            throw new JsonException("Null key.");
        }
        if (object != null) {
            JsonObject.testValidity(object);
            this.myHashMap.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public JsonObject putOpt(String string, Object object) throws JsonException {
        if (string != null && object != null) {
            this.put(string, object);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        int n2 = 0;
        while (n2 < n) {
            char c2 = c;
            c = string.charAt(n2);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    break;
                }
                case '/': {
                    if (c2 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ') {
                        String string2 = "000" + Integer.toHexString(c);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4));
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public Object remove(String string) {
        return this.myHashMap.remove(string);
    }

    static void testValidity(Object object) throws JsonException {
        if (object != null) {
            if (object instanceof Double) {
                if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                    throw new JsonException("JSON does not allow non-finite numbers");
                }
            } else if (object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN())) {
                throw new JsonException("JSON does not allow non-finite numbers.");
            }
        }
    }

    public JsonArray toJSONArray(JsonArray jsonArray) throws JsonException {
        if (jsonArray == null || jsonArray.length() == 0) {
            return null;
        }
        JsonArray jsonArray2 = new JsonArray();
        int n = 0;
        while (n < jsonArray.length()) {
            jsonArray2.put(this.opt(jsonArray.getString(n)));
            ++n;
        }
        return jsonArray2;
    }

    public String toString() {
        try {
            Enumeration enumeration = this.keys();
            StringBuffer stringBuffer = new StringBuffer("{");
            while (enumeration.hasMoreElements()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object e = enumeration.nextElement();
                stringBuffer.append(JsonObject.quote(e.toString()));
                stringBuffer.append(':');
                stringBuffer.append(JsonObject.valueToString(this.myHashMap.get(e)));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n) throws JsonException {
        return this.toString(n, 0);
    }

    /*
     * Unable to fully structure code
     */
    String toString(int var1_1, int var2_2) throws JsonException {
        block7: {
            var4_3 = this.length();
            if (var4_3 == 0) {
                return "{}";
            }
            var5_4 = this.keys();
            var6_5 = new StringBuffer("{");
            var7_6 = var2_2 + var1_1;
            if (var4_3 != 1) ** GOTO lbl35
            var8_7 = var5_4.nextElement();
            var6_5.append(JsonObject.quote(var8_7.toString()));
            var6_5.append(": ");
            var6_5.append(JsonObject.valueToString(this.myHashMap.get(var8_7), var1_1, var2_2));
            break block7;
lbl-1000:
            // 1 sources

            {
                var8_8 = var5_4.nextElement();
                if (var6_5.length() > 1) {
                    var6_5.append(",\n");
                } else {
                    var6_5.append('\n');
                }
                var3_9 = 0;
                while (var3_9 < var7_6) {
                    var6_5.append(' ');
                    ++var3_9;
                }
                var6_5.append(JsonObject.quote(var8_8.toString()));
                var6_5.append(": ");
                var6_5.append(JsonObject.valueToString(this.myHashMap.get(var8_8), var1_1, var7_6));
lbl35:
                // 2 sources

                ** while (var5_4.hasMoreElements())
            }
lbl36:
            // 1 sources

            if (var6_5.length() > 1) {
                var6_5.append('\n');
                var3_9 = 0;
                while (var3_9 < var2_2) {
                    var6_5.append(' ');
                    ++var3_9;
                }
            }
        }
        var6_5.append('}');
        return var6_5.toString();
    }

    static String valueToString(Object object) throws JsonException {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof JsonString) {
            String string;
            try {
                string = ((JsonString)object).toJsonString();
            }
            catch (Exception exception) {
                throw new JsonException(exception);
            }
            if (string instanceof String) {
                return string;
            }
            throw new JsonException("Bad value from toJSONString: " + string);
        }
        if (object instanceof Float || object instanceof Double || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return JsonObject.numberToString(object);
        }
        if (object instanceof Boolean || object instanceof JsonObject || object instanceof JsonArray) {
            return object.toString();
        }
        return JsonObject.quote(object.toString());
    }

    static String valueToString(Object object, int n, int n2) throws JsonException {
        if (object == null || object.equals(null)) {
            return "null";
        }
        try {
            String string;
            if (object instanceof JsonString && (string = ((JsonString)object).toJsonString()) instanceof String) {
                return string;
            }
        }
        catch (Exception exception) {}
        if (object instanceof Float || object instanceof Double || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return JsonObject.numberToString(object);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JsonObject) {
            return ((JsonObject)object).toString(n, n2);
        }
        if (object instanceof JsonArray) {
            return ((JsonArray)object).toString(n, n2);
        }
        return JsonObject.quote(object.toString());
    }

    public Writer write(Writer writer) throws JsonException {
        try {
            boolean bl = false;
            Enumeration enumeration = this.keys();
            writer.write(123);
            while (enumeration.hasMoreElements()) {
                if (bl) {
                    writer.write(44);
                }
                Object e = enumeration.nextElement();
                writer.write(JsonObject.quote(e.toString()));
                writer.write(58);
                Object v = this.myHashMap.get(e);
                if (v instanceof JsonObject) {
                    ((JsonObject)v).write(writer);
                } else if (v instanceof JsonArray) {
                    ((JsonArray)v).write(writer);
                } else {
                    writer.write(JsonObject.valueToString(v));
                }
                bl = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

