/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io.json;

import com.deltopia.io.json.JsonException;
import com.deltopia.io.json.JsonObject;
import com.deltopia.io.json.JsonTokener;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;

public class JsonArray {
    private Vector myArrayList;

    public JsonArray() {
        this.myArrayList = new Vector();
    }

    public JsonArray(JsonTokener jsonTokener) throws JsonException {
        this();
        if (jsonTokener.nextClean() != '[') {
            throw jsonTokener.syntaxError("A JSONArray text must start with '['");
        }
        if (jsonTokener.nextClean() == ']') {
            return;
        }
        jsonTokener.back();
        block4: while (true) {
            if (jsonTokener.nextClean() == ',') {
                jsonTokener.back();
                this.myArrayList.addElement(null);
            } else {
                jsonTokener.back();
                this.myArrayList.addElement(jsonTokener.nextValue());
            }
            switch (jsonTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jsonTokener.nextClean() == ']') {
                        return;
                    }
                    jsonTokener.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw jsonTokener.syntaxError("Expected a ',' or ']'");
    }

    public JsonArray(String string) throws JsonException {
        this(new JsonTokener(string));
    }

    public JsonArray(Vector vector) {
        if (vector == null) {
            this.myArrayList = new Vector();
        } else {
            int n = vector.size();
            this.myArrayList = new Vector(n);
            int n2 = 0;
            while (n2 < n) {
                this.myArrayList.addElement(vector.elementAt(n2));
                ++n2;
            }
        }
    }

    public Object get(int n) throws JsonException {
        Object object = this.opt(n);
        if (object == null) {
            throw new JsonException("JSONArray[" + n + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(int n) throws JsonException {
        Object object = this.get(n);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JsonException("JSONArray[" + n + "] is not a Boolean.");
    }

    public double getDouble(int n) throws JsonException {
        Object object = this.get(n);
        try {
            return Double.valueOf(object.toString());
        }
        catch (Exception exception) {
            throw new JsonException("JSONArray[" + n + "] is not a number.");
        }
    }

    public int getInt(int n) throws JsonException {
        this.get(n);
        return (int)this.getDouble(n);
    }

    public JsonArray getJSONArray(int n) throws JsonException {
        Object object = this.get(n);
        if (object instanceof JsonArray) {
            return (JsonArray)object;
        }
        throw new JsonException("JSONArray[" + n + "] is not a JSONArray.");
    }

    public JsonObject getJSONObject(int n) throws JsonException {
        Object object = this.get(n);
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        throw new JsonException("JSONArray[" + n + "] is not a JSONObject.");
    }

    public long getLong(int n) throws JsonException {
        this.get(n);
        return (long)this.getDouble(n);
    }

    public String getString(int n) throws JsonException {
        return this.get(n).toString();
    }

    public boolean isNull(int n) {
        return JsonObject.NULL.equals(this.opt(n));
    }

    public String join(String string) throws JsonException {
        int n = this.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(JsonObject.valueToString(this.myArrayList.elementAt(n2)));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int n) {
        return n < 0 || n >= this.length() ? null : this.myArrayList.elementAt(n);
    }

    public boolean optBoolean(int n) {
        return this.optBoolean(n, false);
    }

    public boolean optBoolean(int n, boolean bl) {
        try {
            return this.getBoolean(n);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public double optDouble(int n) {
        return this.optDouble(n, Double.NaN);
    }

    public double optDouble(int n, double d) {
        try {
            return this.getDouble(n);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public int optInt(int n) {
        return this.optInt(n, 0);
    }

    public int optInt(int n, int n2) {
        try {
            return this.getInt(n);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public JsonArray optJSONArray(int n) {
        Object object = this.opt(n);
        return object instanceof JsonArray ? (JsonArray)object : null;
    }

    public JsonObject optJSONObject(int n) {
        Object object = this.opt(n);
        return object instanceof JsonObject ? (JsonObject)object : null;
    }

    public long optLong(int n) {
        return this.optLong(n, 0L);
    }

    public long optLong(int n, long l) {
        try {
            return this.getLong(n);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(int n) {
        return this.optString(n, "");
    }

    public String optString(int n, String string) {
        Object object = this.opt(n);
        return object != null ? object.toString() : string;
    }

    public JsonArray put(boolean bl) {
        this.put(bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonArray put(Vector vector) {
        this.put(new JsonArray(vector));
        return this;
    }

    public JsonArray put(double d) throws JsonException {
        Double d2 = new Double(d);
        JsonObject.testValidity(d2);
        this.put(d2);
        return this;
    }

    public JsonArray put(int n) {
        this.put(new Integer(n));
        return this;
    }

    public JsonArray put(long l) {
        this.put(new Long(l));
        return this;
    }

    public JsonArray put(Hashtable hashtable) {
        this.put(new JsonObject(hashtable));
        return this;
    }

    public JsonArray put(Object object) {
        this.myArrayList.addElement(object);
        return this;
    }

    public JsonArray put(int n, boolean bl) throws JsonException {
        this.put(n, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonArray put(int n, Vector vector) throws JsonException {
        this.put(n, new JsonArray(vector));
        return this;
    }

    public JsonArray put(int n, double d) throws JsonException {
        this.put(n, new Double(d));
        return this;
    }

    public JsonArray put(int n, int n2) throws JsonException {
        this.put(n, new Integer(n2));
        return this;
    }

    public JsonArray put(int n, long l) throws JsonException {
        this.put(n, new Long(l));
        return this;
    }

    public JsonArray put(int n, Hashtable hashtable) throws JsonException {
        this.put(n, new JsonObject(hashtable));
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public JsonArray put(int var1_1, Object var2_2) throws JsonException {
        block2: {
            JsonObject.testValidity(var2_2);
            if (var1_1 < 0) {
                throw new JsonException("JSONArray[" + var1_1 + "] not found.");
            }
            if (var1_1 >= this.length()) ** GOTO lbl9
            this.myArrayList.setElementAt(var2_2, var1_1);
            break block2;
lbl-1000:
            // 1 sources

            {
                this.put(JsonObject.NULL);
lbl9:
                // 2 sources

                ** while (var1_1 != this.length())
            }
lbl10:
            // 1 sources

            this.put(var2_2);
        }
        return this;
    }

    public JsonObject toJSONObject(JsonArray jsonArray) throws JsonException {
        if (jsonArray == null || jsonArray.length() == 0 || this.length() == 0) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        int n = 0;
        while (n < jsonArray.length()) {
            jsonObject.put(jsonArray.getString(n), this.opt(n));
            ++n;
        }
        return jsonObject;
    }

    public String toString() {
        try {
            return String.valueOf('[') + this.join(",") + ']';
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n) throws JsonException {
        return this.toString(n, 0);
    }

    String toString(int n, int n2) throws JsonException {
        int n3 = this.length();
        if (n3 == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        if (n3 == 1) {
            stringBuffer.append(JsonObject.valueToString(this.myArrayList.elementAt(0), n, n2));
        } else {
            int n4 = n2 + n;
            stringBuffer.append('\n');
            int n5 = 0;
            while (n5 < n3) {
                if (n5 > 0) {
                    stringBuffer.append(",\n");
                }
                int n6 = 0;
                while (n6 < n4) {
                    stringBuffer.append(' ');
                    ++n6;
                }
                stringBuffer.append(JsonObject.valueToString(this.myArrayList.elementAt(n5), n, n4));
                ++n5;
            }
            stringBuffer.append('\n');
            n5 = 0;
            while (n5 < n2) {
                stringBuffer.append(' ');
                ++n5;
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Writer write(Writer writer) throws JsonException {
        try {
            boolean bl = false;
            int n = this.length();
            writer.write(91);
            int n2 = 0;
            while (n2 < n) {
                Object e;
                if (bl) {
                    writer.write(44);
                }
                if ((e = this.myArrayList.elementAt(n2)) instanceof JsonObject) {
                    ((JsonObject)e).write(writer);
                } else if (e instanceof JsonArray) {
                    ((JsonArray)e).write(writer);
                } else {
                    writer.write(JsonObject.valueToString(e));
                }
                bl = true;
                ++n2;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }
}

