/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.StreamUtil;
import com.deltopia.util.logging.ToString;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipCompressor {
    private static final Logger LOG = LoggerFactory.getLogger(ZipCompressor.class);
    public static final int MAX_COMMENT_LENGTH = 21845;
    private FileFilter filter = null;
    private int level = -1;
    private int method = -1;
    private String comment = null;
    private boolean strict = true;
    private int maxLevel = Integer.MAX_VALUE;

    private static final void compressDir(File file, FileFilter fileFilter, String string, boolean bl, int n, ZipOutputStream zipOutputStream, ISyncProgressMonitor iSyncProgressMonitor, int n2) throws IOException {
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null) {
            if (bl) {
                throw new IOException("Cannot list directory " + file);
            }
            LOG.warn("Cannot list directory " + file);
            return;
        }
        File[] fileArray2 = fileArray;
        int n3 = fileArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string2;
            File file2 = fileArray2[n4];
            String string3 = string2 = string.length() > 0 ? String.valueOf(string) + File.separatorChar + file2.getName() : file2.getName();
            if (file2.isDirectory()) {
                if (n2 <= n) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info(new ToString(n2).append("+ Folder: ", file2.getName()).toString());
                    }
                    ZipCompressor.compressDir(file2, fileFilter, string2, bl, n, zipOutputStream, iSyncProgressMonitor, n2 + 1);
                }
            } else {
                ZipCompressor.compressFile(file2, string2, bl, zipOutputStream, iSyncProgressMonitor, n2);
            }
            ++n4;
        }
    }

    private static final void compressFile(File file, String string, boolean bl, ZipOutputStream zipOutputStream, ISyncProgressMonitor iSyncProgressMonitor, int n) throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info(new ToString(n).append("+ File: ", file.getName()).toString());
        }
        try {
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            long l = file.lastModified();
            zipEntry.setTime(l);
            long l2 = file.length();
            zipEntry.setSize(l2);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                StreamUtil.copyStream(fileInputStream, zipOutputStream, 32768, iSyncProgressMonitor);
            }
            finally {
                StreamUtil.closeSilently(fileInputStream);
            }
        }
        catch (IOException iOException) {
            if (bl) {
                throw iOException;
            }
            LOG.warn("Cannot add to compress " + file, (Throwable)iOException);
        }
        if (iSyncProgressMonitor != null) {
            iSyncProgressMonitor.worked(1);
        }
    }

    public final void compressFolder(File file, File file2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException("Not directory " + file);
        }
        this.compressPaths(Collections.singleton(file), file2, iSyncProgressMonitor);
    }

    public final void compressPaths(Set<File> set, File file, ISyncProgressMonitor iSyncProgressMonitor) throws IOException, NullPointerException, IllegalArgumentException {
        if (set == null) {
            throw new NullPointerException("inList");
        }
        if (set.size() <= 0) {
            throw new IllegalArgumentException("Empty list");
        }
        if (file == null) {
            throw new NullPointerException("outFile");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            try {
                if (this.level != -1) {
                    zipOutputStream.setLevel(this.level);
                }
                if (this.method != -1) {
                    zipOutputStream.setMethod(this.method);
                }
                if (this.comment != null) {
                    zipOutputStream.setComment(this.comment);
                }
                for (File file2 : set) {
                    if (file2.isFile()) {
                        ZipCompressor.compressFile(file2, file2.getName(), this.strict, zipOutputStream, iSyncProgressMonitor, 0);
                        continue;
                    }
                    if (file2.isDirectory()) {
                        ZipCompressor.compressDir(file2, this.filter, "", this.strict, this.maxLevel, zipOutputStream, iSyncProgressMonitor, 0);
                        continue;
                    }
                    LOG.warn("Cannot add to archive missing item: " + file2);
                }
                zipOutputStream.closeEntry();
            }
            finally {
                StreamUtil.closeSilently(zipOutputStream);
            }
        }
        finally {
            StreamUtil.closeSilently(fileOutputStream);
        }
    }

    public void setComment(String string) {
        if (string != null && string.length() > 21845) {
            throw new IllegalArgumentException("Comment too long " + string.length());
        }
        this.comment = string;
    }

    public void setFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    public void setLevel(int n) {
        if ((n < 0 || n > 9) && n != -1) {
            throw new IllegalArgumentException("Compression level: " + n);
        }
        this.level = n;
    }

    public void setMaxLevel(int n) {
        this.maxLevel = n;
    }

    public void setMethod(int n) {
        if (n != -1 && n != 8 && n != 0) {
            throw new IllegalArgumentException("Compression method: " + n);
        }
        this.method = n;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }
}

