/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.IStorageListener;
import com.deltopia.io.StorageEvent;
import com.deltopia.util.Checker;
import com.deltopia.util.PathUtil;
import com.deltopia.util.logging.ToString;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(Watcher.class);
    private static final boolean TRACE = LOG.isDebugEnabled();
    private final WatchService watcher = FileSystems.getDefault().newWatchService();
    private final Registry registry = new Registry();
    private final Monitor monitor;

    public Watcher() throws IOException {
        LOG.info("-> Create");
        this.monitor = new Monitor();
        this.monitor.start();
    }

    final void registerPath(Path path, IStorageListener iStorageListener) throws IOException {
        path = PathUtil.canonize(path);
        Checker.notNull(iStorageListener, "listener");
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        if (!basicFileAttributes.isDirectory()) {
            if (TRACE) {
                LOG.debug("Register parent instead " + path);
            }
            path = path.getParent();
        }
        if (this.monitor.isStopped.get()) {
            throw new IllegalStateException("Already stopped");
        }
        if (this.registry.addPath(path, iStorageListener)) {
            WatchKey watchKey = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.registry.addKey(watchKey, path);
        }
    }

    final void unregisterPath(Path path, IStorageListener iStorageListener) {
        path = PathUtil.canonize(path);
        Checker.notNull(iStorageListener, "listener");
        if (this.monitor.isStopped.get()) {
            LOG.warn("Already stopped");
            return;
        }
        WatchKey watchKey = this.registry.removeListener(path, iStorageListener);
        if (watchKey != null) {
            watchKey.cancel();
        }
    }

    public void stop() {
        this.monitor.requestStop();
    }

    private void unregisterAll() {
        Collection<WatchKey> collection = this.registry.clearAll();
        for (WatchKey watchKey : collection) {
            watchKey.cancel();
        }
        if (TRACE) {
            LOG.debug("Unregister all paths");
        }
    }

    private static final <T> WatchEvent<T> cast(WatchEvent<?> watchEvent) {
        return watchEvent;
    }

    private static final class Entry {
        private final Path path;
        private WatchKey key;
        private final Set<IStorageListener> listeners;

        Entry(Path path, IStorageListener iStorageListener) {
            this.path = Checker.notNull(path, "path");
            this.listeners = new LinkedHashSet<IStorageListener>();
            this.addListener(iStorageListener);
        }

        private Entry(Path path, WatchKey watchKey, Set<IStorageListener> set) {
            this.path = Checker.notNull(path, "path");
            this.key = Checker.notNull(watchKey, "key");
            this.listeners = new LinkedHashSet<IStorageListener>(set);
        }

        public String toString() {
            return this.path + ", key=" + this.key + ", listeners=" + this.listeners.size();
        }

        void setKey(WatchKey watchKey) {
            this.key = Checker.notNull(watchKey, "key");
        }

        void addListener(IStorageListener iStorageListener) {
            Checker.notNull(iStorageListener, "listener");
            boolean bl = this.listeners.add(iStorageListener);
            if (!bl) {
                LOG.warn("Listener already registered: " + iStorageListener);
            } else if (TRACE) {
                LOG.debug("Register " + iStorageListener + " for path " + this.path);
            }
        }

        boolean removeListener(IStorageListener iStorageListener) {
            Checker.notNull(iStorageListener, "listener");
            boolean bl = this.listeners.remove(iStorageListener);
            if (!bl) {
                LOG.warn("Listener is not registered: " + iStorageListener);
            } else if (TRACE) {
                LOG.debug("Unregister " + iStorageListener + " for path " + this.path);
            }
            return this.listeners.isEmpty();
        }

        Entry cloneEntry() {
            return new Entry(this.path, this.key, this.listeners);
        }
    }

    private final class Monitor
    extends Thread {
        private final AtomicBoolean isStopped;

        private Monitor() {
            super("FileSystem Monitor");
            this.isStopped = new AtomicBoolean();
        }

        @Override
        public void run() {
            this.processEvents();
        }

        private void processEvents() {
            if (LOG.isInfoEnabled()) {
                LOG.info("-> Start");
            }
            while (!this.isStopped.get()) {
                boolean bl;
                WatchKey watchKey;
                try {
                    watchKey = Watcher.this.watcher.take();
                }
                catch (InterruptedException interruptedException) {
                    if (this.isStopped.get()) {
                        LOG.info("Service cancelled");
                        break;
                    }
                    LOG.warn("Service interrupted: " + interruptedException);
                    break;
                }
                if (this.isStopped.get()) break;
                Entry entry = Watcher.this.registry.getEntryForKey(watchKey);
                if (entry == null) {
                    LOG.warn("Unknown watch key: " + watchKey);
                    continue;
                }
                Set set = entry.listeners;
                if (!set.isEmpty()) {
                    Path path = entry.path;
                    List<WatchEvent<?>> list = watchKey.pollEvents();
                    if (TRACE) {
                        LOG.debug("Process events: " + list.size());
                    }
                    LinkedHashMap<Integer, Set<Path>> linkedHashMap = new LinkedHashMap<Integer, Set<Path>>(list.size());
                    for (WatchEvent<?> watchEvent : list) {
                        LinkedHashSet<Path> linkedHashSet;
                        int n;
                        if (this.isStopped.get()) break;
                        WatchEvent.Kind<?> kind = watchEvent.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                            n = 2;
                        } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                            n = 2;
                        } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                            n = 4;
                        } else {
                            LOG.warn("Unknown kind: " + kind);
                            continue;
                        }
                        WatchEvent watchEvent2 = Watcher.cast(watchEvent);
                        Path path2 = (Path)watchEvent2.context();
                        Path path3 = path.resolve(path2);
                        if (TRACE) {
                            LOG.debug(String.format("Got event %s: %s\n", watchEvent.kind().name(), path3));
                        }
                        if ((linkedHashSet = (LinkedHashSet<Path>)linkedHashMap.get(n)) == null) {
                            linkedHashSet = new LinkedHashSet<Path>();
                            linkedHashMap.put(n, linkedHashSet);
                        }
                        if (linkedHashSet.add(path3) || !TRACE) continue;
                        LOG.debug("Duplicated path: " + path3);
                    }
                    if (!linkedHashMap.isEmpty()) {
                        this.notifyListeners(set, linkedHashMap);
                    }
                } else {
                    LOG.warn("No listeners: " + entry);
                    watchKey.cancel();
                }
                if (bl = watchKey.reset()) continue;
                Watcher.this.registry.removeKeyAndPath(watchKey);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("<- Stopped");
            }
            Watcher.this.unregisterAll();
        }

        private void notifyListeners(Set<IStorageListener> set, Map<Integer, Set<Path>> map) {
            for (Map.Entry<Integer, Set<Path>> entry : map.entrySet()) {
                Set<Path> set2 = entry.getValue();
                Object[] objectArray = PathUtil.toEclipsePaths(set2);
                StorageEvent storageEvent = new StorageEvent(this, entry.getKey(), objectArray);
                for (IStorageListener iStorageListener : set) {
                    try {
                        iStorageListener.storageChanged(storageEvent);
                    }
                    catch (Exception exception) {
                        LOG.warn("Notification failed with " + storageEvent + " to " + iStorageListener, (Throwable)exception);
                    }
                }
            }
        }

        void requestStop() {
            this.isStopped.set(true);
            Watcher.this.monitor.interrupt();
        }
    }

    private static final class Registry {
        private final Map<WatchKey, Path> keys = new LinkedHashMap<WatchKey, Path>();
        private final Map<Path, Entry> paths = new LinkedHashMap<Path, Entry>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Registry registry = this;
            synchronized (registry) {
                return new ToString().append("Paths:", this.paths.values()).toString();
            }
        }

        synchronized void addKey(WatchKey watchKey, Path path) {
            Entry entry = this.paths.get(path);
            if (entry != null) {
                if (TRACE) {
                    Path path2 = this.keys.get(watchKey);
                    if (path2 == null) {
                        LOG.debug(String.format("Register key: %s", path));
                    } else if (!path.equals(path2)) {
                        LOG.debug(String.format("Replace key: %s -> %s", path2, path));
                    }
                }
                entry.setKey(watchKey);
                this.keys.put(watchKey, path);
            } else {
                LOG.warn("Key removed meanwhile " + path);
            }
        }

        synchronized boolean addPath(Path path, IStorageListener iStorageListener) {
            Entry entry = this.paths.get(path);
            if (entry == null) {
                entry = new Entry(path, iStorageListener);
                this.paths.put(path, entry);
                return true;
            }
            entry.addListener(iStorageListener);
            return false;
        }

        synchronized Collection<WatchKey> clearAll() {
            ArrayList<WatchKey> arrayList = new ArrayList<WatchKey>(this.keys.keySet());
            this.keys.clear();
            this.paths.clear();
            return arrayList;
        }

        synchronized WatchKey removeListener(Path path, IStorageListener iStorageListener) {
            WatchKey watchKey = null;
            Entry entry = this.paths.get(path);
            if (entry == null) {
                path = path.getParent();
                entry = this.paths.get(path);
            }
            if (entry != null) {
                if (entry.removeListener(iStorageListener)) {
                    this.paths.remove(path);
                    if (this.keys.remove(entry.key) == null) {
                        LOG.warn("No key to remove for path");
                    } else {
                        watchKey = entry.key;
                        if (TRACE) {
                            LOG.debug(String.format("Unregister: %s", path));
                        }
                    }
                }
            } else {
                LOG.warn("No path to unregister: " + path + (LOG.isInfoEnabled() ? ", current: " + this : ""));
            }
            return watchKey;
        }

        synchronized void removeKeyAndPath(WatchKey watchKey) {
            Checker.notNull(watchKey, "key");
            Path path = this.keys.remove(watchKey);
            if (path != null) {
                if (this.paths.remove(path) == null) {
                    LOG.warn("No path to remove " + path + " for key: " + watchKey);
                } else if (TRACE) {
                    LOG.debug("Remove path " + path + " with key: " + watchKey);
                }
            } else {
                LOG.warn("No key to remove: " + watchKey);
            }
        }

        synchronized Entry getEntryForKey(WatchKey watchKey) {
            Path path = this.keys.get(watchKey);
            if (path == null) {
                return null;
            }
            Entry entry = this.paths.get(path);
            if (entry == null) {
                return new Entry(path, watchKey, Collections.emptySet());
            }
            return entry.cloneEntry();
        }
    }
}

