/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.StringUtil;
import com.deltopia.io.FileUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VfsUtil {
    public static final String _COLON = ":";
    public static final String _SCHEMA_SUFFIX = "://";
    public static final String BZ2 = "bz2";
    public static final Set<String> CLOUD_SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("google", "dropbox")));
    public static final String DROPBOX = "dropbox";
    public static final String DROPBOX_ = "dropbox://";
    public static final String EAR = "ear";
    public static final String FILE = "file";
    public static final String FILE_ = "file://";
    public static final String FTP = "ftp";
    public static final String FTP_ = "ftp://";
    public static final String FTPS = "ftps";
    public static final String FTPS_ = "ftps://";
    public static final String GOOGLE = "google";
    public static final String GOOGLE_ = "google://";
    public static final String GZ = "gz";
    public static final String HTTP = "http";
    public static final String HTTP_ = "http://";
    public static final String HTTPS = "https";
    public static final String HTTPS_ = "https://";
    public static final String JAR = "jar";
    static Pattern ptnArchiveExtension = Pattern.compile("(\\Qzip\\E)|(\\Qjar\\E)|(\\Qear\\E)|(\\Qwar\\E)|(\\Qtar\\E)|(\\Qgz\\E)|(\\Qtgz\\E)|(\\Qbz2\\E)|(\\Qtbz2\\E)", 66);
    static Pattern ptnArchiveScheme = Pattern.compile("(\\Qzip:\\E)|(\\Qjar:\\E)|(\\Qear:\\E)|(\\Qwar\\E)|(\\Qtar:\\E)|(\\Qgz:\\E)|(\\Qtgz:\\E)|(\\Qbz2:\\E)|(\\Qtbz2:\\E)", 66);
    static Pattern ptnRemoteScheme = Pattern.compile("(\\Qftp://\\E)|(\\Qftps://\\E)|(\\Qsftp://\\E)|(\\Qhttp://\\E)|(\\Qhttps://\\E)|(\\Qwebdav://\\E)|(\\Qwebdavs://\\E)|(\\Qsmb://\\E)|(\\Qdropbox://\\E)|(\\Qgoogle://\\E)", 66);
    public static char[] RESERVED_CHARS = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ',', '[', ']'};
    public static final String SFTP = "sftp";
    public static final String SFTP_ = "sftp://";
    public static final String SMB = "smb";
    public static final String SMB_ = "smb://";
    public static final String TAR = "tar";
    public static final String TAR_ = "tar://";
    public static final String TAR__ = "tar:";
    public static final String TBZ2 = "tbz2";
    public static final String TBZ2_ = "tbz2://";
    public static final String TBZ2__ = "tbz2:";
    public static final String TGZ = "tgz";
    public static final String WAR = "war";
    public static final String WEBDAV = "webdav";
    public static final String WEBDAV_ = "webdav://";
    public static final String WEBDAVS = "webdavs";
    public static final String WEBDAVS_ = "webdavs://";
    public static final String ZIP = "zip";

    public static int getDefaultPort(String string, boolean bl) {
        String string2 = string.toLowerCase();
        if (!string2.endsWith(_SCHEMA_SUFFIX)) {
            string2 = String.valueOf(string2) + _SCHEMA_SUFFIX;
        }
        if (string2.equals(FTP_)) {
            return 21;
        }
        if (string2.equals(FTPS_)) {
            return bl ? 21 : 990;
        }
        if (string2.equals(SFTP_)) {
            return 22;
        }
        if (string2.equals(HTTP_) || string2.equals(WEBDAV_)) {
            return 80;
        }
        if (string2.equals(HTTPS_) || string2.equals(WEBDAVS_)) {
            return 443;
        }
        if (string2.equals(SMB_)) {
            return 445;
        }
        if (string2.equals(DROPBOX_) || string2.equals(GOOGLE_)) {
            return 445;
        }
        return -1;
    }

    public static String getRootName(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        int n2 = n - 1;
        while (n2 > 0 && stringBuilder.charAt(n2) != '!') {
            --n2;
        }
        if (n2 == 0 && stringBuilder.charAt(n2) != '!') {
            n2 = n;
        }
        String string = stringBuilder.substring(0, n2);
        if (n2 < n) {
            stringBuilder.delete(0, n2 + 1);
        } else {
            stringBuilder.setLength(0);
        }
        return string;
    }

    public static String getScheme(String string) {
        String string2 = "";
        int n = string.indexOf(_SCHEMA_SUFFIX);
        if (n > -1) {
            string2 = string.substring(0, n);
            int n2 = string2.indexOf(58);
            string2 = n2 == -1 ? string2 : string2.substring(0, n2);
        }
        return string2.toLowerCase();
    }

    public static boolean hasArchiveExtension(String string) {
        return VfsUtil.isArchiveExtension(FileUtil.getExtension(string));
    }

    public static boolean hasArchiveScheme(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        Matcher matcher = ptnArchiveScheme.matcher(string);
        if (matcher.find()) {
            return matcher.start() == 0;
        }
        return false;
    }

    public static boolean hasCompositeScheme(String string) {
        String string2 = string.replace('\\', '/');
        int n = string2.indexOf(_SCHEMA_SUFFIX);
        if (n > -1) {
            String string3 = string2.substring(0, n);
            return string3.indexOf(58) > -1;
        }
        return false;
    }

    public static boolean hasRemoteScheme(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        return ptnRemoteScheme.matcher(string).find();
    }

    public static boolean hasVfsScheme(String string) {
        return VfsUtil.hasRemoteScheme(string) || VfsUtil.hasArchiveScheme(string);
    }

    public static boolean isArchiveExtension(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        return ptnArchiveExtension.matcher(string).matches();
    }

    public static final boolean isCloudScheme(String string) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Invalid scheme: " + string);
        }
        return CLOUD_SCHEMES.contains(string);
    }

    public static boolean isVfsUri(String string) {
        return VfsUtil.hasVfsScheme(string) || VfsUtil.hasArchiveExtension(string);
    }

    private VfsUtil() {
    }
}

