/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.Msg;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum VfsService {
    DROPBOX("dropbox", Msg.VfsService_scheme_dropbox),
    FTP("ftp", Msg.VfsService_scheme_ftp),
    FTPS("ftps", Msg.VfsService_scheme_ftps),
    GOOGLE("google", Msg.VfsService_scheme_googleDrive),
    HTTP("http", Msg.VfsService_scheme_http),
    HTTPS("https", Msg.VfsService_scheme_https),
    SFTP("sftp", Msg.VfsService_scheme_sftp),
    WEBDAV("webdav", Msg.VfsService_scheme_webdav),
    WEBDAVS("webdavs", Msg.VfsService_scheme_webdavs);

    private static final Set<String> CLOUD_SCHEMES;
    private final String displayName;
    private final String fullScheme;
    private final String scheme;

    static {
        CLOUD_SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(GOOGLE.scheme(), DROPBOX.scheme())));
    }

    public static int count() {
        return VfsService.values().length;
    }

    private VfsService(String string2, String string3) {
        this.scheme = string2;
        this.displayName = string3;
        this.fullScheme = String.valueOf(this.scheme) + "://";
    }

    public Set<String> cloudSchemes() {
        return CLOUD_SCHEMES;
    }

    public String displayName() {
        return this.displayName;
    }

    public String fullScheme() {
        return this.fullScheme;
    }

    public String scheme() {
        return this.scheme;
    }
}

