/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.internal.io.BaseFileSystem;
import com.deltopia.io.IFileSystem;
import com.deltopia.io.IO;
import java.io.IOException;

public class UrlEx {
    private long pointer;
    private String path;

    public static final UrlEx fromBookmark(byte[] byArray) throws IOException {
        UrlEx urlEx = UrlEx.getFS().urlFromBookmark(byArray);
        return urlEx;
    }

    public static final UrlEx fromPath(String string) throws IOException {
        UrlEx urlEx = UrlEx.getFS().urlFromPath(string);
        return urlEx;
    }

    private static final BaseFileSystem getFS() throws UnsupportedOperationException {
        IFileSystem iFileSystem = IO.fileSystem();
        if (!(iFileSystem instanceof BaseFileSystem)) {
            throw new UnsupportedOperationException("No native FS");
        }
        return (BaseFileSystem)iFileSystem;
    }

    UrlEx(String string, long l) {
        if (0L == l) {
            throw new IllegalArgumentException("0 pointer");
        }
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("path: " + string);
        }
        this.path = string;
        this.pointer = l;
    }

    public synchronized boolean allowSecureAccess(boolean bl) {
        this.checkReleased();
        return UrlEx.getFS().allowSecureAccess(this.pointer, bl);
    }

    private void checkReleased() {
        if (this.pointer == 0L) {
            throw new IllegalStateException("Released " + this);
        }
    }

    public String getPath() {
        return this.path;
    }

    public synchronized void release() {
        this.checkReleased();
        UrlEx.getFS().urlRelease(this.pointer);
        this.pointer = 0L;
    }

    public final synchronized byte[] toBookmark() throws IOException {
        this.checkReleased();
        byte[] byArray = UrlEx.getFS().urlToBookmark(this.pointer);
        return byArray;
    }

    public synchronized String toString() {
        return "'" + this.path + "' " + (this.pointer == 0L ? "Released" : "@@" + this.pointer);
    }
}

