/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.httpclient.NameValuePair;

public class URLEncodedUtils {
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";

    public static List<NameValuePair> parse(URI uRI, String string) {
        List<NameValuePair> list = Collections.emptyList();
        String string2 = uRI.getRawQuery();
        if (string2 != null && string2.length() > 0) {
            list = new ArrayList<NameValuePair>();
            URLEncodedUtils.parse(list, new Scanner(string2), string);
        }
        return list;
    }

    public static Map<String, String[]> parseToMap(URI uRI, String string) {
        List<NameValuePair> list = URLEncodedUtils.parse(uRI, string);
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        for (NameValuePair nameValuePair : list) {
            String[] stringArray = (String[])linkedHashMap.get(nameValuePair.getName());
            stringArray = stringArray == null ? new String[1] : Arrays.copyOf(stringArray, stringArray.length + 1);
            stringArray[stringArray.length - 1] = nameValuePair.getValue();
            linkedHashMap.put(nameValuePair.getName(), stringArray);
        }
        return linkedHashMap;
    }

    public static void parse(List<NameValuePair> list, Scanner scanner, String string) {
        scanner.useDelimiter(PARAMETER_SEPARATOR);
        while (scanner.hasNext()) {
            String[] stringArray = scanner.next().split(NAME_VALUE_SEPARATOR);
            if (stringArray.length == 0 || stringArray.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String string2 = URLEncodedUtils.decode(stringArray[0], string);
            String string3 = null;
            if (stringArray.length == 2) {
                string3 = URLEncodedUtils.decode(stringArray[1], string);
            }
            list.add(new NameValuePair(string2, string3));
        }
    }

    public static String format(List<? extends NameValuePair> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (NameValuePair nameValuePair : list) {
            String string2;
            String string3 = URLEncodedUtils.encode(nameValuePair.getName(), string);
            String string4 = nameValuePair.getValue();
            String string5 = string2 = string4 != null ? URLEncodedUtils.encode(string4, string) : "";
            if (stringBuilder.length() > 0) {
                stringBuilder.append(PARAMETER_SEPARATOR);
            }
            stringBuilder.append(string3);
            stringBuilder.append(NAME_VALUE_SEPARATOR);
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static final String getValue(Collection<NameValuePair> collection, String string) {
        if (collection == null) {
            throw new NullPointerException("list");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        for (NameValuePair nameValuePair : collection) {
            if (!nameValuePair.getName().equalsIgnoreCase(string)) continue;
            return nameValuePair.getValue();
        }
        return null;
    }

    public static String getValue(Map<String, String[]> map, String string) {
        if (map == null) {
            throw new NullPointerException("list");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        String[] stringArray = map.get(string);
        return stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
    }

    private static String decode(String string, String string2) {
        try {
            return URLDecoder.decode(string, string2 != null ? string2 : DEFAULT_CONTENT_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }

    private static String encode(String string, String string2) {
        try {
            return URLEncoder.encode(string, string2 != null ? string2 : DEFAULT_CONTENT_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }
}

