/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.BomHeader;
import com.deltopia.util.Checker;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextEncoding {
    private static final Logger LOG = LoggerFactory.getLogger(TextEncoding.class);
    private static final Map<BomHeader, TextEncoding> MAP_WITH_BOM;
    private static final TextEncoding UTF8_NO_BOM;
    private final BomHeader bom;
    private final String charset;

    static {
        UTF8_NO_BOM = new TextEncoding(StandardCharsets.UTF_8.name(), null);
        BomHeader[] bomHeaderArray = BomHeader.values();
        LinkedHashMap<BomHeader, TextEncoding> linkedHashMap = new LinkedHashMap<BomHeader, TextEncoding>(bomHeaderArray.length);
        BomHeader[] bomHeaderArray2 = bomHeaderArray;
        int n = bomHeaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            BomHeader bomHeader = bomHeaderArray2[n2];
            TextEncoding textEncoding = new TextEncoding(bomHeader.charset(), bomHeader);
            linkedHashMap.put(bomHeader, textEncoding);
            ++n2;
        }
        MAP_WITH_BOM = Collections.unmodifiableMap(linkedHashMap);
    }

    public static final TextEncoding fromBomHeader(BomHeader bomHeader) {
        Checker.notNull(bomHeader, "bomHeader");
        TextEncoding textEncoding = MAP_WITH_BOM.get((Object)bomHeader);
        if (textEncoding == null) {
            throw new IllegalStateException();
        }
        return textEncoding;
    }

    public static TextEncoding fromCharset(String string) {
        Checker.notEmpty(string, "charset");
        try {
            string = Charset.forName(string).name();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            LOG.warn("Unknown charset: " + string);
        }
        catch (Exception exception) {
            LOG.warn("Invalid charset: " + string, (Throwable)exception);
        }
        if (TextEncoding.UTF8_NO_BOM.charset.equals(string)) {
            return UTF8_NO_BOM;
        }
        return new TextEncoding(string, null);
    }

    public static TextEncoding fromUiCharset(String string) {
        Checker.notEmpty(string, "uiCharset");
        BomHeader bomHeader = BomHeader.fromUiCharsetOpt(string);
        if (bomHeader != null) {
            return TextEncoding.fromBomHeader(bomHeader);
        }
        return TextEncoding.fromCharset(string);
    }

    public static final TextEncoding getDefault() {
        return UTF8_NO_BOM;
    }

    private TextEncoding(String string, BomHeader bomHeader) {
        this.charset = Checker.notEmpty(string, "charset");
        this.bom = bomHeader;
    }

    public final BomHeader bom() {
        return this.bom;
    }

    public final String charset() {
        return this.charset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextEncoding textEncoding = (TextEncoding)object;
        return Objects.equals(this.charset, textEncoding.charset) && this.bom == textEncoding.bom;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.charset, this.bom});
    }

    public String toString() {
        return this.charset + (this.bom != null ? ", BOM=" + (Object)((Object)this.bom) : "");
    }

    public final String uiCharset() {
        return this.bom != null ? this.bom.uiCharset() : this.charset;
    }
}

