/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.ITempFileBoss;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TempFileBoss
implements ITempFileBoss {
    public static final String PROP_TEMP_DIR = "com.deltawalker.temp.dir";
    public static final String PROP_DELAY_FAIL = "com.deltawalker.temp.clean.delay";
    public static final String PROP_LIMIT = "com.deltawalker.temp.limit";
    private static final Logger LOG;
    private static final boolean TRACE = true;
    private static final ITempFileBoss self;
    private final File tempDir;
    private final String filePrefix;
    private final int limit;
    private final long delayAfterFail;
    private Timer timer = null;
    private final LinkedHashMap<File, Boolean> files;

    static {
        ITempFileBoss iTempFileBoss;
        LOG = LoggerFactory.getLogger((String)"com.deltopia.io.TempFileBoss");
        try {
            iTempFileBoss = new TempFileBoss();
        }
        catch (IOException iOException) {
            LOG.error("Cannot create temp file manager", (Throwable)iOException);
            iTempFileBoss = new TempFileBossDummy();
        }
        self = iTempFileBoss;
    }

    private static final void createDir(File file) throws IOException {
        if (!file.mkdirs() && !file.isDirectory()) {
            throw new IOException("Cannot create directory " + file);
        }
    }

    public static final File getDefaultTempDir() {
        File file;
        String string = System.getProperty(PROP_TEMP_DIR);
        if (string == null) {
            String string2 = System.getProperty("java.io.tmpdir");
            File file2 = new File(string2);
            file = new File(file2, "DeltaWalker");
            LOG.info("Use default temporary directory: " + string2);
        } else {
            LOG.info("Use predefined temporary directory: " + string);
            file = new File(string);
        }
        return file;
    }

    public static final ITempFileBoss getInstance() {
        return self;
    }

    private static final int getIntProp(String string, int n) {
        assert (string != null);
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                int n2 = Integer.parseInt(string2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("Invalid property " + string + "=" + string2, (Throwable)numberFormatException);
            }
        }
        return n;
    }

    private TempFileBoss() throws IOException {
        this(TempFileBoss.getDefaultTempDir(), "DW_", TempFileBoss.getIntProp(PROP_LIMIT, 100), TempFileBoss.getIntProp(PROP_DELAY_FAIL, 20000));
    }

    TempFileBoss(File file, String string, int n, long l) throws IOException {
        assert (file != null);
        assert (string != null);
        if (string.length() < 3 || string.length() > 16) {
            throw new IllegalArgumentException("Invalid prefix: " + string);
        }
        assert (n >= 10);
        assert (l > 0L);
        TempFileBoss.createDir(file);
        this.tempDir = file;
        this.filePrefix = string;
        this.limit = n;
        this.delayAfterFail = l;
        this.files = new LinkedHashMap(n);
        this.revalidate(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup(long l) {
        ArrayList<File> arrayList;
        LinkedHashMap<File, Boolean> serializable2 = this.files;
        synchronized (serializable2) {
            arrayList = new ArrayList<File>(this.files.size());
            for (Map.Entry<File, Boolean> entry : this.files.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                arrayList.add(entry.getKey());
            }
        }
        LOG.info("Cleanup files=" + arrayList.size());
        for (File file : arrayList) {
            this.deleteTempFile(file);
            if (l <= 0L) continue;
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                LOG.error("Cleanup interrupted", (Throwable)interruptedException);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File createTempFile() throws IOException {
        File file = File.createTempFile(this.filePrefix, ".dat", this.tempDir);
        LOG.info("Create temp file: " + file);
        File file2 = null;
        LinkedHashMap<File, Boolean> linkedHashMap = this.files;
        synchronized (linkedHashMap) {
            if (this.files.get(file) == null) {
                this.files.put(file, Boolean.FALSE);
            } else {
                LOG.warn("Already registered: " + file);
            }
            if (this.files.size() > this.limit) {
                for (Map.Entry<File, Boolean> entry : this.files.entrySet()) {
                    if (entry.getValue().booleanValue()) continue;
                    file2 = entry.getKey();
                    break;
                }
            }
        }
        if (file2 != null) {
            this.deleteTempFile(file2);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteTempFile(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.delete() && file.exists()) {
            LOG.warn("Cannot delete temp file: " + file);
            file.deleteOnExit();
            Object object = this.files;
            synchronized (object) {
                this.files.put(file, Boolean.TRUE);
            }
            object = this;
            synchronized (object) {
                if (this.timer == null) {
                    this.timer = new Timer("Temp file cleaner", true);
                    CleanTask cleanTask = new CleanTask();
                    LOG.info("Schedule cleanup after " + this.delayAfterFail + " ms");
                    this.timer.schedule((TimerTask)cleanTask, this.delayAfterFail);
                }
            }
            return false;
        }
        LOG.info("Deleted temp file: " + file);
        LinkedHashMap<File, Boolean> linkedHashMap = this.files;
        synchronized (linkedHashMap) {
            if (this.files.remove(file) == null) {
                LOG.warn("Not registered: " + file);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revalidate(long l) {
        File[] fileArray = this.tempDir.listFiles(new FileOnlyFilter());
        if (fileArray != null && fileArray.length > 0) {
            LOG.info("Startup cleanup files=" + fileArray.length);
            LinkedHashMap<File, Boolean> linkedHashMap = this.files;
            synchronized (linkedHashMap) {
                this.files.clear();
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray2[n2];
                    this.files.put(file, Boolean.TRUE);
                    ++n2;
                }
            }
            this.cleanup(l);
        }
    }

    private final class CleanTask
    extends TimerTask {
        private CleanTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                try {
                    try {
                        LOG.info("-> Scheduled cleanup");
                        TempFileBoss.this.cleanup(20L);
                    }
                    catch (Exception exception) {
                        LOG.error("Clean failed", (Throwable)exception);
                        TempFileBoss tempFileBoss = TempFileBoss.this;
                        synchronized (tempFileBoss) {
                            TempFileBoss.this.timer.cancel();
                            TempFileBoss.this.timer = null;
                            break block14;
                        }
                    }
                }
                catch (Throwable throwable) {
                    TempFileBoss tempFileBoss = TempFileBoss.this;
                    synchronized (tempFileBoss) {
                        TempFileBoss.this.timer.cancel();
                        TempFileBoss.this.timer = null;
                    }
                    throw throwable;
                }
                TempFileBoss tempFileBoss = TempFileBoss.this;
                synchronized (tempFileBoss) {
                    TempFileBoss.this.timer.cancel();
                    TempFileBoss.this.timer = null;
                }
            }
        }
    }

    private static final class FileOnlyFilter
    implements FileFilter {
        private FileOnlyFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile();
        }
    }

    private static final class TempFileBossDummy
    implements ITempFileBoss {
        private TempFileBossDummy() {
        }

        @Override
        public void cleanup(long l) {
        }

        @Override
        public File createTempFile() throws IOException {
            throw new IOException("Cannot create temp file");
        }

        @Override
        public boolean deleteTempFile(File file) throws NullPointerException {
            return true;
        }

        @Override
        public void revalidate(long l) {
        }
    }
}

