/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.FileInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class StructFileInfo {
    private List<StructFileInfo> children;
    private final FileInfo fileInfo;
    private final StructFileInfo parent;

    public StructFileInfo(FileInfo fileInfo, StructFileInfo structFileInfo) {
        this.fileInfo = fileInfo;
        this.parent = structFileInfo != null && structFileInfo.isDirectory() ? structFileInfo : null;
    }

    public synchronized void addChild(StructFileInfo structFileInfo) {
        if (this.children == null) {
            this.children = new ArrayList<StructFileInfo>(2);
        }
        this.children.add(structFileInfo);
    }

    public FileInfo fileInfo() {
        return this.fileInfo;
    }

    public synchronized List<StructFileInfo> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    public StructFileInfo getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return this.fileInfo.isDirectory();
    }

    public String name() {
        return this.fileInfo.name();
    }

    public synchronized void setChildren(List<StructFileInfo> list) {
        if (this.children == null) {
            this.children = new CopyOnWriteArrayList<StructFileInfo>();
        }
        this.children.clear();
        this.children.addAll(list);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.fileInfo.toString());
        if (this.parent != null) {
            stringBuilder.append(" parent=" + this.parent.name());
        }
        if (this.children != null && !this.children.isEmpty()) {
            stringBuilder.append(" [");
            for (StructFileInfo structFileInfo : this.children) {
                stringBuilder.append(structFileInfo.name());
                stringBuilder.append(", ");
            }
            stringBuilder = new StringBuilder(stringBuilder.substring(0, stringBuilder.length() - 2));
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

