/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.interfaces.ISyncProgressMonitor;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StreamUtil.class);

    public static final void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Cannot close " + closeable, (Throwable)iOException);
                }
                LOG.info("Cannot close " + closeable + ": " + iOException.getMessage());
            }
        }
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream, int n, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        int n2;
        if (n <= 0) {
            n = 16384;
        }
        byte[] byArray = new byte[n];
        long l = 0L;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            if (iSyncProgressMonitor != null && !iSyncProgressMonitor.bytesTransferred(n2)) {
                return l;
            }
            l += (long)n2;
        }
        if (iSyncProgressMonitor != null) {
            iSyncProgressMonitor.itemTransferred();
        }
        return l;
    }

    public static final boolean readFromFile(File file, int n, StringBuilder stringBuilder) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (stringBuilder == null) {
            throw new NullPointerException("outBuf");
        }
        if (n <= 0) {
            return true;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            long l = file.length();
            int n2 = StreamUtil.readFromStream(fileInputStream, (int)Math.min(l, (long)n), stringBuilder);
            boolean bl = (long)n2 == l;
            return bl;
        }
        finally {
            StreamUtil.closeSilently(fileInputStream);
        }
    }

    public static final int readFromStream(InputStream inputStream, int n, StringBuilder stringBuilder) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("stream");
        }
        if (stringBuilder == null) {
            throw new NullPointerException("outBuf");
        }
        int n2 = Math.min(n, 65536);
        if (n2 <= 0) {
            return 0;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = ((Reader)inputStreamReader).read(cArray, 0, Math.min(cArray.length, n - n3));
            if (n4 < 0) break;
            stringBuilder.append(cArray, 0, n4);
            n3 += n4;
        }
        return n3;
    }

    private StreamUtil() {
    }
}

