/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.StringUtil;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.CancelTransferException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private final String name;
    private final ISyncProgressMonitor spm;
    private long total = 0L;

    public ProgressMonitorInputStream(String string, InputStream inputStream, ISyncProgressMonitor iSyncProgressMonitor) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException("input stream");
        }
        if (iSyncProgressMonitor == null) {
            throw new NullPointerException("monitor");
        }
        this.name = StringUtil.isEmpty(string) ? inputStream.toString() : string;
        this.spm = iSyncProgressMonitor;
    }

    public long getTotalBytes() {
        return this.total;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n > 0) {
            this.report(1);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.report(n3);
        }
        return n3;
    }

    protected void report(int n) throws IOException {
        boolean bl = this.spm.bytesTransferred(n);
        if (!bl) {
            throw new CancelTransferException("Cancel operation of " + this.toString());
        }
        this.total += (long)n;
    }

    public String toString() {
        return this.name;
    }
}

