/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.PipedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class PipedInputStream
extends InputStream {
    boolean closedByWriter = false;
    volatile boolean closedByReader = false;
    boolean connected = false;
    Thread readSide;
    Thread writeSide;
    private static final int DEFAULT_PIPE_SIZE = 1024;
    protected byte[] buffer;
    protected int in = -1;
    protected int out = 0;

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        this(pipedOutputStream, 1024);
    }

    public PipedInputStream(PipedOutputStream pipedOutputStream, int n) throws IOException {
        this.initPipe(n);
        this.connect(pipedOutputStream);
    }

    public PipedInputStream() {
        this.initPipe(1024);
    }

    public PipedInputStream(int n) {
        this.initPipe(n);
    }

    private void initPipe(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Pipe Size <= 0");
        }
        this.buffer = new byte[n];
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        pipedOutputStream.connect(this);
    }

    protected synchronized void receive(int n) throws IOException {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        if (this.in == this.out) {
            this.awaitSpace();
        }
        if (this.in < 0) {
            this.in = 0;
            this.out = 0;
        }
        this.buffer[this.in++] = (byte)(n & 0xFF);
        if (this.in >= this.buffer.length) {
            this.in = 0;
        }
    }

    synchronized void receive(byte[] byArray, int n, int n2) throws IOException {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        int n3 = n2;
        while (n3 > 0) {
            if (this.in == this.out) {
                this.awaitSpace();
            }
            int n4 = 0;
            if (this.out < this.in) {
                n4 = this.buffer.length - this.in;
            } else if (this.in < this.out) {
                if (this.in == -1) {
                    this.out = 0;
                    this.in = 0;
                    n4 = this.buffer.length - this.in;
                } else {
                    n4 = this.out - this.in;
                }
            }
            if (n4 > n3) {
                n4 = n3;
            }
            assert (n4 > 0);
            System.arraycopy(byArray, n, this.buffer, this.in, n4);
            n3 -= n4;
            n += n4;
            this.in += n4;
            if (this.in < this.buffer.length) continue;
            this.in = 0;
        }
    }

    private void checkStateForReceive() throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByWriter || this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.readSide != null) {
            this.readSide.isAlive();
        }
    }

    private void awaitSpace() throws IOException {
        while (this.in == this.out) {
            this.checkStateForReceive();
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
    }

    synchronized void receivedLast() {
        this.closedByWriter = true;
        this.notifyAll();
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.writeSide != null && !this.writeSide.isAlive() && !this.closedByWriter && this.in < 0) {
            throw new IOException("Write end dead");
        }
        this.readSide = Thread.currentThread();
        int n = 2;
        while (this.in < 0) {
            if (this.closedByWriter) {
                return -1;
            }
            if (this.writeSide != null && !this.writeSide.isAlive() && --n < 0) {
                throw new IOException("Pipe broken");
            }
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        int n2 = this.buffer[this.out++] & 0xFF;
        if (this.out >= this.buffer.length) {
            this.out = 0;
        }
        if (this.in == this.out) {
            this.in = -1;
        }
        return n2;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 < 0) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        while (this.in >= 0 && n2 > 1) {
            int n5 = this.in > this.out ? Math.min(this.buffer.length - this.out, this.in - this.out) : this.buffer.length - this.out;
            if (n5 > n2 - 1) {
                n5 = n2 - 1;
            }
            System.arraycopy(this.buffer, this.out, byArray, n + n4, n5);
            this.out += n5;
            n4 += n5;
            n2 -= n5;
            if (this.out >= this.buffer.length) {
                this.out = 0;
            }
            if (this.in != this.out) continue;
            this.in = -1;
        }
        return n4;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.in < 0) {
            return 0;
        }
        if (this.in == this.out) {
            return this.buffer.length;
        }
        if (this.in > this.out) {
            return this.in - this.out;
        }
        return this.in + this.buffer.length - this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.closedByReader = true;
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            this.in = -1;
        }
    }
}

