/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.IO;
import com.deltopia.io.StreamUtil;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IniFileUtil.class);

    public static void copyFile(File file, File file2) throws IOException {
        if (file == null) {
            throw new NullPointerException("srcFile");
        }
        if (file2 == null) {
            throw new NullPointerException("dstFile");
        }
        if (!file2.exists()) {
            file2.createNewFile();
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    private static File createTempFile() throws IOException {
        return File.createTempFile("$_dw_ini_$", ".tmp");
    }

    public static void setNameValuePair(File file, String string, String string2, String string3, String string4) {
        boolean bl;
        boolean bl2;
        block13: {
            if (string == null) {
                throw new NullPointerException("section");
            }
            if (string2 == null) {
                throw new NullPointerException("name");
            }
            if (string2.isEmpty()) {
                throw new IllegalArgumentException("name cannot be empty");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(NLS.bind((String)"Writing ''{0}'': ''{1}'' to ''{2}''", (Object[])new String[]{string2, string3, file.toString()}));
            }
            bl2 = false;
            bl = false;
            string = string.replaceAll(" ", "");
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                try {
                    try {
                        String string5;
                        while ((string5 = bufferedReader.readLine()) != null) {
                            String string6 = string5;
                            string5 = string5.replaceAll(" ", "");
                            string5 = string5.replaceAll("\\t", "");
                            if (!string.isEmpty() && string5.equalsIgnoreCase(string)) {
                                bl2 = true;
                            }
                            if (!IniFileUtil.startsWith(string6, string2, false)) continue;
                            bl = true;
                        }
                    }
                    catch (Throwable throwable) {
                        LOG.error("Couldn't set name/value pair", throwable);
                        StreamUtil.closeSilently(bufferedReader);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    StreamUtil.closeSilently(bufferedReader);
                    throw throwable;
                }
                StreamUtil.closeSilently(bufferedReader);
            }
            catch (Throwable throwable) {
                LOG.error("Couldn't set name/value pair", throwable);
            }
        }
        IniFileUtil.writeNameValuePair(file, string, string2, string3, bl2, bl, string4);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getValueForName(File var0, String var1_1, String var2_2, boolean var3_3) {
        if (var1_1 == null) {
            throw new NullPointerException("section");
        }
        if (var2_2 == null) {
            throw new NullPointerException("name");
        }
        if (var2_2.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        var1_1 = var1_1.replaceAll(" ", "");
        try {
            var6_4 = new BufferedReader(new InputStreamReader(new FileInputStream(var0)));
            try {
                block11: do lbl-1000:
                // 3 sources

                {
                    do {
                        if ((var5_7 = var6_4.readLine()) == null) {
                            return "";
                        }
                        var4_6 = var5_7;
                        var5_7 = var5_7.replaceAll(" ", "");
                        var5_7 = var5_7.replaceAll("\\t", "");
                        if (var1_1.isEmpty()) continue block11;
                    } while (!var5_7.equalsIgnoreCase(var1_1));
                    if (!IniFileUtil.startsWith(var4_6, var2_2, false)) ** GOTO lbl-1000
                    if (var3_3) {
                        var9_8 = var6_4.readLine();
                        return var9_8;
                    }
                    var9_9 = var4_6;
                    return var9_9;
                } while (!IniFileUtil.startsWith(var4_6, var2_2, false));
                if (var3_3) {
                    var9_10 = var6_4.readLine();
                    return var9_10;
                }
                var9_11 = var4_6;
                return var9_11;
            }
            catch (Throwable var7_12) {
                IniFileUtil.LOG.error("Couldn't set name/value pair", var7_12);
                return "";
            }
            finally {
                StreamUtil.closeSilently(var6_4);
            }
        }
        catch (Throwable var6_5) {
            IniFileUtil.LOG.error("Couldn't set name/value pair", var6_5);
        }
        return "";
    }

    private static boolean startsWith(String string, String string2, boolean bl) {
        string = string.replaceAll(" ", "");
        string = string.replaceAll("\\t", "");
        return string.regionMatches(bl, 0, string2, 0, string2.length());
    }

    public static File getWritableAppIniFile(boolean bl) {
        File file = null;
        try {
            String string;
            IProduct iProduct;
            String string2;
            String string3 = Platform.getInstanceLocation().getURL().getPath();
            if (LOG.isInfoEnabled()) {
                LOG.info("Instance path: " + string3);
            }
            if ((string2 = (iProduct = Platform.getProduct()).getName()).startsWith("Deltopia")) {
                string2 = string2.substring("Deltopia".length(), string2.length()).trim();
            }
            if (bl) {
                string2 = string2.toLowerCase();
            }
            if (!(file = new File(string3, string = String.valueOf(string2) + ".ini")).isFile()) {
                String string4 = Platform.getInstallLocation().getURL().getPath();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Initial install path: " + string4);
                }
                File file2 = new File(string4, string);
                if (OS.OSX && !file2.isFile()) {
                    if (string4.endsWith("/Contents/MacOS/")) {
                        string4 = string4.substring(0, string4.length() - "MacOS/".length());
                        string4 = String.valueOf(string4) + "Resources/";
                    } else if (string4.endsWith("/Contents/Java/")) {
                        string4 = string4.substring(0, string4.length() - "Java/".length());
                        string4 = String.valueOf(string4) + "Resources/";
                    }
                    file2 = new File(string4, string);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Adjusted install path: " + string4);
                    }
                }
                if (file2.isFile()) {
                    IO.fileSystem().copyFile(file2.getCanonicalPath(), file.getCanonicalPath(), null);
                } else {
                    file = null;
                }
            }
        }
        catch (IOException iOException) {
            file = null;
            LOG.error("Couldn't get a writable App.ini file: ", (Throwable)iOException);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("INI file: " + file);
        }
        return file;
    }

    private static void writeNameValuePair(File file, String string, String string2, String string3, boolean bl, boolean bl2, String string4) {
        boolean bl3 = Const.LINE_ENDING.equals(string4);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            File file2 = IniFileUtil.createTempFile();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file2)));
            try {
                try {
                    String string5;
                    if (!string.isEmpty() && !bl) {
                        printWriter.println(string);
                    }
                    boolean bl4 = true;
                    if (!bl2) {
                        printWriter.println(String.valueOf(string2) + string4 + string3);
                        bl4 = false;
                    }
                    while ((string5 = bufferedReader.readLine()) != null) {
                        if (!bl4) {
                            printWriter.println(string5);
                            continue;
                        }
                        String string6 = string5;
                        string5 = string5.replaceAll(" ", "");
                        if (IniFileUtil.startsWith(string5 = string5.replaceAll("\\t", ""), string2, false)) {
                            printWriter.println(String.valueOf(string2) + string4 + string3);
                            if (!bl3) continue;
                            bl4 = false;
                            if (bufferedReader.readLine() != null) continue;
                            break;
                        }
                        printWriter.println(string6);
                    }
                }
                catch (Throwable throwable) {
                    LOG.error("Couldn't write name/value pair", throwable);
                    StreamUtil.closeSilently(bufferedReader);
                    printWriter.flush();
                    StreamUtil.closeSilently(printWriter);
                    IniFileUtil.copyFile(file2, file);
                    file2.deleteOnExit();
                }
            }
            finally {
                StreamUtil.closeSilently(bufferedReader);
                printWriter.flush();
                StreamUtil.closeSilently(printWriter);
                IniFileUtil.copyFile(file2, file);
                file2.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't write name/value pair", throwable);
        }
    }
}

