/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.DefaultFileSystem;
import com.deltopia.io.IFileSystem;
import org.eclipse.core.runtime.Platform;

public final class IO {
    private static final IFileSystem fileSystem;
    static final boolean SUPPORT_EX_PERMISSION;

    static {
        Class<?> clazz;
        Object object;
        String string;
        if (Platform.isRunning()) {
            string = Platform.getOS();
        } else {
            object = System.getProperty("os.name").toLowerCase();
            if (((String)object).startsWith("win")) {
                string = "win32";
            } else if (((String)object).startsWith("lin")) {
                string = "linux";
            } else if (((String)object).startsWith("mac")) {
                string = "macosx";
            } else {
                System.err.println("Unknown OS: " + (String)object);
                string = "unknown";
            }
        }
        SUPPORT_EX_PERMISSION = !string.equals("win32");
        object = null;
        String string2 = "com.deltopia.internal.io." + string + ".FileSystem";
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
            System.err.println("No " + string2 + ", using DefaultFileSystem.");
        }
        if (clazz != null) {
            try {
                object = (IFileSystem)clazz.newInstance();
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
        }
        if (object == null) {
            object = DefaultFileSystem.getInstance();
        }
        fileSystem = object;
    }

    public static IFileSystem fileSystem() {
        return fileSystem;
    }

    private IO() {
    }
}

