/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.interfaces.IPrincipal;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.FileInfo;
import com.deltopia.io.IFile;
import com.deltopia.io.IStorageListener;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public interface IFileSystem {
    public static final String RESOURCE_FORK_SUFFIX = "/..namedfork/rsrc";

    public boolean isStorageListenerSupported();

    public void addStorageListener(File var1, IStorageListener var2);

    public Menu attachContextMenu(Control var1, Menu var2, Set<File> var3) throws IOException, UnsupportedOperationException;

    public boolean compareByteByByte(File var1, File var2, IProgressMonitor var3) throws IOException;

    public long copyFile(IFile var1, IFile var2, ISyncProgressMonitor var3) throws IOException;

    public long copyFile(String var1, String var2, ISyncProgressMonitor var3) throws IOException;

    public void createSymbolicLink(File var1, String var2, boolean var3) throws IOException, UnsupportedOperationException;

    public boolean delete(File var1, boolean var2);

    public FileInfo getFileInfo(File var1) throws IOException;

    public IPrincipal getGroup(Object var1) throws IOException;

    public int getSupportedAttributes();

    public Image getThumbnail(Device var1, File var2, int var3, int var4);

    public IPrincipal getUser(Object var1) throws IOException;

    public boolean isContextMenuSupported();

    public boolean isCreateSymbolicLinkSupported();

    public boolean isMoveToTrashSupported();

    public boolean isReadSymbolicLinkSupported();

    public boolean isUrlExSupported();

    public FileInfo[] listFileInfos(File var1, int var2, IProgressMonitor var3, int var4) throws IOException;

    public long moveFile(IFile var1, IFile var2, ISyncProgressMonitor var3) throws IOException;

    public String readSymbolicLink(String var1) throws IOException, UnsupportedOperationException;

    public byte[] readSymbolicLinkData(String var1) throws IOException, UnsupportedOperationException;

    public void removeStorageListener(File var1, IStorageListener var2);

    public void setFileInfo(File var1, FileInfo var2, int var3) throws IOException;
}

