/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.StringUtil;
import com.deltopia.io.SerializationUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;

public final class HexStringUtil {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String convertByteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            stringBuffer.append(HEX_CHARS[(by & 0xF0) >>> 4]);
            stringBuffer.append(HEX_CHARS[by & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static int convertHexCharToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("hexChar");
    }

    public static byte[] convertHexStringToByteArray(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("hexString");
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = HexStringUtil.convertHexCharToNibble(string.charAt(n2));
            int n5 = HexStringUtil.convertHexCharToNibble(string.charAt(n2 + 1));
            byArray[n3] = (byte)(n4 << 4 | n5);
            n2 += 2;
            ++n3;
        }
        return byArray;
    }

    static String[] getPublicParentPackageNames(String string) {
        Object[] objectArray = string.split("\\.");
        int n = 0;
        while (n < objectArray.length - 1 && !"internal".equals(objectArray[n])) {
            ++n;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n > 0) {
            arrayList.add(StringUtil.join(objectArray, 0, n, Character.toString('.')));
            --n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Object readObject(String string) throws ClassNotFoundException, IOException {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        byte[] byArray = HexStringUtil.convertHexStringToByteArray(string);
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray)){

            protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                try {
                    return super.resolveClass(objectStreamClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return SerializationUtil.resolveClass(objectStreamClass.getName(), classNotFoundException);
                }
            }
        };){
            Object object = objectInputStream.readObject();
            return object;
        }
    }

    public static String writeObject(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(object);
        }
        return HexStringUtil.convertByteArrayToHexString(byteArrayOutputStream.toByteArray());
    }

    private HexStringUtil() {
    }
}

