/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.StringUtil;
import com.deltopia.io.VfsUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static Map<String, ProgramInfo> imgCache = new HashMap<String, ProgramInfo>();
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    public static boolean absolutelyExists(File file) {
        return file != null && file.isAbsolute() && file.exists();
    }

    public static boolean absolutelyExists(String string) {
        return !StringUtil.isEmpty(string) && FileUtil.absolutelyExists(new File(string));
    }

    public static String defaultSlashes(String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        return string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String getExtension(String string) {
        String string2;
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n > -1 && (string2 = string.substring(n + 1)).indexOf(File.separatorChar) == -1) {
            return string2;
        }
        return "";
    }

    public static String getFileName(String string) {
        return FileUtil.getFileName(string, true);
    }

    public static String getFileName(String string, boolean bl) {
        if (string != null) {
            int n;
            int n2 = Math.max((string = FileUtil.stripTrailingPathSeparators(string)).lastIndexOf(47), string.lastIndexOf(92));
            if (n2 >= 0 && n2 < string.length()) {
                string = string.substring(n2 + 1);
            }
            if (!bl && -1 < (n = string.lastIndexOf(46))) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public static ProgramInfo getImageFromExtension(String string, Point point) {
        Image image;
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        if (imgCache.containsKey(string)) {
            return imgCache.get(string);
        }
        ProgramInfo programInfo = null;
        Program program = Program.findProgram((String)string);
        if (program != null && (image = program.getImage()) != null) {
            programInfo = new ProgramInfo(image, program.getName());
        }
        imgCache.put(string, programInfo);
        return programInfo;
    }

    public static String getPathStem(String string) {
        int n;
        if (string != null && (n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92))) >= 0 && n + 1 < string.length()) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    public static String replaceExtension(String string, String string2) {
        String string3 = FileUtil.getExtension(string);
        if (!StringUtil.isEmpty(string3)) {
            return String.valueOf(string.substring(0, string.lastIndexOf(string3))) + "txt";
        }
        return string;
    }

    public static String resolvePath(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("arg");
        }
        if (string.isEmpty()) {
            return string;
        }
        String string3 = null;
        if (LOG.isInfoEnabled()) {
            string3 = string;
        }
        if (!VfsUtil.hasVfsScheme(string)) {
            File file = new File(string).getAbsoluteFile();
            if (!file.exists()) {
                if (StringUtil.isEmpty(string2) || !new File(string2).getAbsoluteFile().exists()) {
                    string2 = StringUtil.makeSafe(System.getenv().get("PWD"));
                }
                if (!StringUtil.isEmpty(string2)) {
                    file = new File(string2, string);
                }
                if (file.exists()) {
                    string = file.getPath();
                } else {
                    LOG.info(NLS.bind((String)"''{0}'' cannot be resolved.", (Object)string));
                }
            } else {
                String string4 = file.toString();
                if (!string.equals(string4)) {
                    string = string4;
                }
            }
        }
        if (LOG.isInfoEnabled() && !string.equals(string3)) {
            LOG.info("RESOLVED: " + string3 + "   AS: " + string);
        }
        return string;
    }

    public static String stripTrailingPathSeparators(String string) {
        int n = string.length();
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (c != '/' && c != '\\') break;
            n = n2--;
        }
        return string.substring(0, n);
    }

    private FileUtil() {
    }

    public static class ProgramInfo {
        public final Image image;
        public final String name;

        public ProgramInfo(Image image, String string) {
            this.image = image;
            this.name = string;
        }
    }
}

