/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import java.util.HashMap;
import java.util.Map;

public enum FileType {
    FILE("File", "icons/full/elcl16/file.png"),
    FOLDER("Folder", "icons/full/elcl16/folder.png"),
    UNKNOWN("Unknown", "");

    private static final Map<String, FileType> strToEnum;
    private final String imagePath;
    private final String name;

    static {
        strToEnum = new HashMap<String, FileType>();
        FileType[] fileTypeArray = FileType.values();
        int n = fileTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileType fileType = fileTypeArray[n2];
            strToEnum.put(fileType.name, fileType);
            ++n2;
        }
    }

    public static int compare(FileType fileType, FileType fileType2) {
        if (fileType == FOLDER && fileType2 == FILE) {
            return 1;
        }
        if (fileType == FILE && fileType2 == FOLDER) {
            return -1;
        }
        return 0;
    }

    public static FileType fromString(String string) {
        FileType fileType = strToEnum.get(string);
        return fileType != null ? fileType : UNKNOWN;
    }

    private FileType(String string2, String string3) {
        this.name = string2;
        this.imagePath = string3;
    }

    public String displayName() {
        return this.name;
    }

    public String imagePath() {
        return this.imagePath;
    }

    public boolean isFile() {
        return this == FILE;
    }

    public boolean isFolder() {
        return this == FOLDER;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public String toString() {
        return this.name;
    }
}

