/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.StringUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileInfo {
    public static final int A_DIRECTORY = 1;
    public static final int A_HIDDEN = 32;
    public static final int A_SYM_LINK = 64;
    public static final int A_SYSTEM = 128;
    public static final int A_ARCHIVE = 256;
    public static final int A_ALL = 481;
    public static final int P_EXEC_GROUP = 0x200000;
    public static final int P_EXEC_OTHERS = 0x1000000;
    public static final int P_EXEC_USER = 262144;
    public static final int P_READ_GROUP = 524288;
    public static final int P_READ_OTHERS = 0x400000;
    public static final int P_READ_USER = 65536;
    public static final int P_WRITE_GROUP = 0x100000;
    public static final int P_WRITE_OTHERS = 0x800000;
    public static final int P_WRITE_USER = 131072;
    public static final int P_SET_USER_ID = 0x2000000;
    public static final int P_SET_GROUP_ID = 0x4000000;
    public static final int P_RESTRICT = 0x8000000;
    public static final int P_READ = 0x490000;
    public static final int P_WRITE = 0x920000;
    public static final int P_EXEC = 19136512;
    public static final int P_IO_ALL = 0x1FF0000;
    public static final int P_ALL = 0xFFF0000;
    private static final int ALL_FLAGS = 268370401;
    public static final int PERMISSIONS = 1;
    public static final int ATTRIBUTES = 2;
    public static final int LAST_MODIFIED_TIME = 4;
    public static final int LAST_ACCESS_TIME = 8;
    public static final int CREATION_TIME = 16;
    public static final int UID = 32;
    public static final int GID = 64;
    public static final int FIELD_MASK_ALL = 127;
    public static final int FIELD_MASK_LIST = 7;
    public static final int FIELD_MASK_LIST_EX = 127;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss:SSS Z");
    private final int attributes;
    private final long lastModified;
    private final String name;
    private final long size;

    public static final FileInfo createFromPath(File file) {
        String string;
        long l;
        int n = 0;
        if (file.isDirectory()) {
            l = 0L;
            n = 1;
        } else {
            l = file.length();
        }
        long l2 = file.lastModified();
        if (file.isHidden()) {
            n |= 0x20;
        }
        if (file.canRead()) {
            n |= 0x490000;
        }
        if (file.canWrite()) {
            n |= 0x920000;
        }
        if (file.canExecute()) {
            n |= 0x1240000;
        }
        return new FileInfo(StringUtil.isEmpty(string = file.getName()) ? file.getPath() : string, n, l, l2);
    }

    public static boolean hasPermission(int n, int n2) {
        return (n & n2) == n2;
    }

    public static final boolean isSet(int n, int n2) {
        return (n & n2) != 0;
    }

    public static final String toStringAttributes(int n) {
        StringBuilder stringBuilder = new StringBuilder(18);
        if (FileInfo.isSet(n, 64)) {
            stringBuilder.append('l');
        } else {
            stringBuilder.append(FileInfo.isSet(n, 1) ? (char)'d' : '-');
        }
        stringBuilder.append(FileInfo.isSet(n, 65536) ? (char)'r' : '-');
        stringBuilder.append(FileInfo.isSet(n, 131072) ? (char)'w' : '-');
        stringBuilder.append(FileInfo.isSet(n, 262144) ? (char)'x' : '-');
        stringBuilder.append(FileInfo.isSet(n, 0x2000000) ? (char)'s' : '-');
        stringBuilder.append(' ');
        stringBuilder.append(FileInfo.isSet(n, 524288) ? (char)'r' : '-');
        stringBuilder.append(FileInfo.isSet(n, 0x100000) ? (char)'w' : '-');
        stringBuilder.append(FileInfo.isSet(n, 0x200000) ? (char)'x' : '-');
        stringBuilder.append(FileInfo.isSet(n, 0x4000000) ? (char)'s' : '-');
        stringBuilder.append(' ');
        stringBuilder.append(FileInfo.isSet(n, 0x400000) ? (char)'r' : '-');
        stringBuilder.append(FileInfo.isSet(n, 0x800000) ? (char)'w' : '-');
        stringBuilder.append(FileInfo.isSet(n, 0x1000000) ? (char)'x' : '-');
        stringBuilder.append(' ');
        stringBuilder.append(FileInfo.isSet(n, 0x8000000) ? (char)'b' : '-');
        stringBuilder.append(FileInfo.isSet(n, 32) ? (char)'h' : '-');
        stringBuilder.append(FileInfo.isSet(n, 128) ? (char)'s' : '-');
        stringBuilder.append(FileInfo.isSet(n, 256) ? (char)'a' : '-');
        return stringBuilder.toString();
    }

    protected static final String toStringDate(Date date) {
        if (date == null) {
            return "null";
        }
        return String.valueOf(DATE_FORMAT.format(date)) + " [" + date.getTime() + "]";
    }

    protected static final String toStringTime(long l) {
        return FileInfo.toStringDate(new Date(l));
    }

    public FileInfo(String string, int n, long l, long l2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (l < -1L) {
            throw new IllegalArgumentException("Negative file size:" + l);
        }
        if ((n & 0xF000FE1E) != 0) {
            throw new IllegalArgumentException("Unknown attributes: " + n);
        }
        this.name = string;
        this.size = l;
        this.lastModified = l2;
        this.attributes = n;
    }

    public final int attributes() {
        return this.attributes;
    }

    public FileInfo cloneUsingNewAttributes(int n) {
        return new FileInfo(this.name, n, this.size, this.lastModified);
    }

    public FileInfo cloneUsingNewAttributesAndLastModifiedTime(int n, long l) {
        return new FileInfo(this.name, n, this.size, l);
    }

    public FileInfo cloneUsingNewLastModifiedTime(long l) {
        return new FileInfo(this.name, this.attributes, this.size, l);
    }

    public FileInfo cloneUsingNewName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        return new FileInfo(string, this.attributes, this.size, this.lastModified);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileInfo)) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)object;
        return this.name.equals(fileInfo.name) && this.size == fileInfo.size && this.lastModified == fileInfo.lastModified && this.attributes == fileInfo.attributes;
    }

    public boolean equalsSettable(FileInfo fileInfo) {
        if (fileInfo == null) {
            return false;
        }
        return this.lastModified == fileInfo.lastModified && this.attributes == fileInfo.attributes;
    }

    public final boolean hasPermission(int n) {
        return (this.attributes & n) == n;
    }

    public final boolean isArchive() {
        return this.isSet(256);
    }

    public final boolean isDirectory() {
        return this.isSet(1);
    }

    public final boolean isHidden() {
        return this.isSet(32);
    }

    public final boolean isReadable() {
        return this.hasPermission(65536);
    }

    protected final boolean isSet(int n) {
        return (this.attributes & n) != 0;
    }

    public final boolean isSymbolicLink() {
        return this.isSet(64);
    }

    public final boolean isSystem() {
        return this.isSet(128);
    }

    public final boolean isWritable() {
        return this.hasPermission(131072);
    }

    public final long lastModifiedTime() {
        return this.lastModified;
    }

    public final String name() {
        return this.name;
    }

    public final int permissions() {
        return this.attributes & 0xFFF0000;
    }

    public final long size() {
        return this.size;
    }

    public String toString() {
        return "'" + this.name + '\'' + ", size=" + this.size + ", lastModifiedTime=" + FileInfo.toStringTime(this.lastModified) + ", attr=" + FileInfo.toStringAttributes(this.attributes);
    }
}

