/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.StringUtil;
import com.deltopia.interfaces.ICopyFrom;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.internal.io.AbstractFileSystem;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileInfoEx;
import com.deltopia.io.IDeleteProgressMonitor;
import com.deltopia.io.IFile;
import com.deltopia.io.IO;
import com.deltopia.io.IStorageListener;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.Watcher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.activation.FileTypeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileSystem
extends AbstractFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFileSystem.class);
    private static final DefaultFileSystem self = new DefaultFileSystem();
    private static final boolean USE_JDK7_FOR_ATTRIBUTES = true;
    private static final int SIZE_BUF_COMPARE = 65536;
    private static final int SUPPORTED_ATTRIBUTES = 0x7FF0000;
    private final Watcher watcher;

    public static boolean absolutelyExists(File file) {
        return file.isAbsolute() && file.exists();
    }

    public static boolean absolutelyExists(String string) {
        File file = new File(string);
        return file.isAbsolute() && file.exists();
    }

    public static long copyDelete(IFile iFile, IFile iFile2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        long l = DefaultFileSystem.copyFileImpl(iFile, iFile2, false, iSyncProgressMonitor);
        iFile.setFileInfo(iFile.getFileInfo().cloneUsingNewName(iFile2.getName()));
        DefaultFileSystem.deleteFile(iFile, iSyncProgressMonitor);
        return l;
    }

    public static long copyFileImpl(IFile iFile, IFile iFile2, boolean bl, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        if (iFile == null) {
            throw new NullPointerException("src");
        }
        if (iFile2 == null) {
            throw new NullPointerException("dst");
        }
        long l = 0L;
        l = iFile.isLocal() && iFile2.isLocal() ? DefaultFileSystem.copyUsingFileChannel(iFile, iFile2, iSyncProgressMonitor) : DefaultFileSystem.copyUsingStream(iFile, iFile2, iSyncProgressMonitor);
        if (bl) {
            try {
                iFile2.setFileInfo(iFile.getFileInfo());
            }
            catch (Throwable throwable) {
                LOG.error("Couldn't set FileInfo for " + iFile2, throwable);
            }
        }
        return l;
    }

    private static long copyUsingStream(IFile iFile, IFile iFile2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        InputStream inputStream = iFile.createInputStream(false);
        try {
            long l;
            if (iFile2 instanceof ICopyFrom) {
                ICopyFrom iCopyFrom = (ICopyFrom)((Object)iFile2);
                String string = iFile.getName();
                String string2 = FileTypeMap.getDefaultFileTypeMap().getContentType(string);
                l = iCopyFrom.copyFrom(inputStream, string, string2, iFile.getLastModifiedTime(), iSyncProgressMonitor);
            } else {
                OutputStream outputStream = iFile2.createOutputStream(false);
                try {
                    l = StreamUtil.copyStream(inputStream, outputStream, 0, iSyncProgressMonitor);
                }
                finally {
                    StreamUtil.closeSilently(outputStream);
                }
            }
            long l2 = l;
            return l2;
        }
        finally {
            StreamUtil.closeSilently(inputStream);
        }
    }

    private static long copyUsingFileChannel(IFile iFile, IFile iFile2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        String string = iFile.getPath();
        String string2 = iFile2.getPath();
        long l = DefaultFileSystem.copyUsingFileChannel(string, iFile.size(), string2, iSyncProgressMonitor);
        long l2 = iFile.resourceForkSize();
        if (l2 > 0L) {
            DefaultFileSystem.copyUsingFileChannel(String.valueOf(string) + "/..namedfork/rsrc", l2, String.valueOf(string2) + "/..namedfork/rsrc", null);
        }
        return l;
    }

    /*
     * Exception decompiling
     */
    public static final long copyUsingFileChannel(String var0, long var1_1, String var3_2, ISyncProgressMonitor var4_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final void deleteFile(IFile iFile, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        if (iSyncProgressMonitor != null && iSyncProgressMonitor.isCanceled()) {
            return;
        }
        if (!iFile.delete() && iFile.exists()) {
            String string = "Couldn't delete: " + iFile;
            LOG.error(string);
            throw new IOException(string);
        }
    }

    public static final boolean deletePath(File file, IDeleteProgressMonitor iDeleteProgressMonitor) {
        IDeleteProgressMonitor.Action action = file.isDirectory() ? DefaultFileSystem.deleteRecursively(file, iDeleteProgressMonitor) : DefaultFileSystem.deleteSingle(file, iDeleteProgressMonitor);
        return action == null;
    }

    private static final IDeleteProgressMonitor.Action deleteRecursively(File file, IDeleteProgressMonitor iDeleteProgressMonitor) {
        File[] fileArray;
        IDeleteProgressMonitor.Action action = null;
        int n = 0;
        while ((fileArray = file.listFiles()) == null) {
            ++n;
            LOG.warn("Failed to list contents of " + file);
            if (file.exists()) {
                if (iDeleteProgressMonitor != null) {
                    action = iDeleteProgressMonitor.itemListFailed(file, n);
                    if (action == null) {
                        throw new IllegalStateException("Should not return null");
                    }
                } else {
                    action = IDeleteProgressMonitor.Action.CANCEL;
                }
            } else {
                return null;
            }
            if (action != null && action == IDeleteProgressMonitor.Action.RETRY) continue;
        }
        if (action != null) {
            return action;
        }
        assert (fileArray != null);
        IDeleteProgressMonitor.Action action2 = null;
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray2[n3];
            IDeleteProgressMonitor.Action action3 = file2.isDirectory() ? DefaultFileSystem.deleteRecursively(file2, iDeleteProgressMonitor) : DefaultFileSystem.deleteSingle(file2, iDeleteProgressMonitor);
            if (action3 != null) {
                action2 = action3;
                if (action3 == IDeleteProgressMonitor.Action.CANCEL) {
                    return action3;
                }
            }
            ++n3;
        }
        if (action2 == null) {
            return DefaultFileSystem.deleteSingle(file, iDeleteProgressMonitor);
        }
        return action2;
    }

    private static final IDeleteProgressMonitor.Action deleteSingle(File file, IDeleteProgressMonitor iDeleteProgressMonitor) {
        IDeleteProgressMonitor.Action action;
        int n = 0;
        do {
            if (!file.delete() && file.exists()) {
                ++n;
                LOG.warn("Cannot delete path: " + file);
                if (iDeleteProgressMonitor != null) {
                    action = iDeleteProgressMonitor.itemDeleteFailed(file, n);
                    if (action != null) continue;
                    throw new IllegalStateException("Should not return null");
                }
                action = IDeleteProgressMonitor.Action.CANCEL;
                continue;
            }
            action = iDeleteProgressMonitor != null ? (iDeleteProgressMonitor.itemDeleted(file) ? null : IDeleteProgressMonitor.Action.CANCEL) : null;
            return action;
        } while (action == IDeleteProgressMonitor.Action.RETRY);
        return action;
    }

    public static final DefaultFileSystem getInstance() {
        return self;
    }

    public static FileInfo[] listFileInfosDefault(File file) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Cannot list files for: " + file);
        }
        FileInfo[] fileInfoArray = new FileInfo[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            fileInfoArray[n] = FileInfo.createFromPath(fileArray[n]);
            ++n;
        }
        return fileInfoArray;
    }

    public static final long moveUsingFileChannel(IFile iFile, IFile iFile2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        long l = DefaultFileSystem.copyUsingFileChannel(iFile, iFile2, iSyncProgressMonitor);
        DefaultFileSystem.deleteFile(iFile, iSyncProgressMonitor);
        return l;
    }

    public static long moveUsingFileStream(IFile iFile, IFile iFile2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        long l = DefaultFileSystem.copyUsingStream(iFile, iFile2, iSyncProgressMonitor);
        DefaultFileSystem.deleteFile(iFile, iSyncProgressMonitor);
        return l;
    }

    public static final <T extends IFile> void renameFile(T t, T t2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        if (!t.getClass().isInstance(t2)) {
            throw new IOException("Cannot rename a resource as the source/destination resources are of different types: " + t + " to " + t2);
        }
        try {
            if (t2.exists() && t2.isLocal()) {
                IO.fileSystem().delete(new File(t2.getPath()), true);
            }
            t2.renameTo(t.getUri(), null, true);
            if (iSyncProgressMonitor != null) {
                iSyncProgressMonitor.bytesTransferred(t2.size());
                iSyncProgressMonitor.itemTransferred();
            }
        }
        catch (IOException iOException) {
            if (t.isLocal() && t2.isLocal()) {
                DefaultFileSystem.moveUsingFileChannel(t, t2, iSyncProgressMonitor);
            }
            DefaultFileSystem.moveUsingFileStream(t, t2, iSyncProgressMonitor);
        }
    }

    private DefaultFileSystem() {
        super(EnumSet.of(AbstractFileSystem.Feature.DIR_LIST, new AbstractFileSystem.Feature[]{AbstractFileSystem.Feature.COPY, AbstractFileSystem.Feature.MOVE, AbstractFileSystem.Feature.COMPARE_BB, AbstractFileSystem.Feature.GET_FILE_INFO, AbstractFileSystem.Feature.SET_FILE_INFO, AbstractFileSystem.Feature.STORAGE_LISTENER}), 0x7FF0000);
        Watcher watcher = null;
        try {
            watcher = new Watcher();
        }
        catch (IOException iOException) {
            LOG.warn("Cannot create watcher", (Throwable)iOException);
            this.disableSupportedFeature(AbstractFileSystem.Feature.STORAGE_LISTENER);
        }
        this.watcher = watcher;
    }

    @Override
    public void addStorageListener(File file, IStorageListener iStorageListener) {
        if (this.watcher != null) {
            try {
                this.watcher.registerPath(file.toPath(), iStorageListener);
            }
            catch (IOException iOException) {
                LOG.warn("Cannot register " + file, (Throwable)iOException);
            }
        }
    }

    @Override
    public void removeStorageListener(File file, IStorageListener iStorageListener) {
        if (this.watcher != null) {
            this.watcher.unregisterPath(file.toPath(), iStorageListener);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean compareByteByByte(File var1_1, File var2_2, IProgressMonitor var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long copyFile(IFile iFile, IFile iFile2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        return DefaultFileSystem.copyFileImpl(iFile, iFile2, true, iSyncProgressMonitor);
    }

    @Override
    public long copyFile(String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        return DefaultFileSystem.copyUsingFileChannel(string, new File(string).length(), string2, iSyncProgressMonitor);
    }

    @Override
    public boolean delete(File file, boolean bl) {
        return file.delete();
    }

    @Override
    protected FileInfo getFileInfoImpl(File file) throws NullPointerException, IOException {
        return this.getFileInfoJDK7(file);
    }

    @Override
    protected FileInfo[] listFileInfosImpl(File file, int n, IProgressMonitor iProgressMonitor, int n2) throws IOException {
        return DefaultFileSystem.listFileInfosDefault(file);
    }

    @Override
    public long moveFile(IFile iFile, IFile iFile2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        if (!this.isSupported(AbstractFileSystem.Feature.MOVE)) {
            throw new UnsupportedOperationException("moveFile");
        }
        if (iFile == null) {
            throw new NullPointerException("srcFile");
        }
        if (iFile2 == null) {
            throw new NullPointerException("dstFile");
        }
        long l = 0L;
        boolean bl = true;
        try {
            if (iFile.getClass().isInstance(iFile2)) {
                DefaultFileSystem.renameFile(iFile, iFile2, iSyncProgressMonitor);
                l = iFile2.size();
            } else {
                bl = false;
                l = DefaultFileSystem.copyDelete(iFile, iFile2, iSyncProgressMonitor);
            }
        }
        catch (IOException iOException) {
            if (bl) {
                l = DefaultFileSystem.copyDelete(iFile, iFile2, iSyncProgressMonitor);
            }
            throw new IOException("Cannot move file: " + iFile.getPath() + " to " + iFile.getPath());
        }
        return l;
    }

    @Override
    protected void setFileInfoImpl(File file, FileInfo fileInfo, int n) throws NullPointerException, IOException {
        this.setFileInfoJDK7(file, fileInfo, n);
    }

    private final FileInfo getFileInfoJDK7(File file) throws IOException {
        Object object;
        Object object2;
        long l;
        Path path = file.toPath();
        Class<? extends BasicFileAttributes> clazz = this.getAttributesType(path);
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, clazz, LinkOption.NOFOLLOW_LINKS);
        String string = path.getFileName().toString();
        if (StringUtil.isEmpty(string)) {
            string = file.getPath();
        }
        int n = 0;
        if (basicFileAttributes.isDirectory()) {
            l = 0L;
            n |= 1;
        } else {
            l = basicFileAttributes.size();
        }
        long l2 = DefaultFileSystem.timeToMs(basicFileAttributes.lastModifiedTime());
        long l3 = DefaultFileSystem.timeToMs(basicFileAttributes.creationTime());
        long l4 = DefaultFileSystem.timeToMs(basicFileAttributes.lastAccessTime());
        if (basicFileAttributes.isSymbolicLink()) {
            n |= 0x40;
        }
        if (basicFileAttributes instanceof DosFileAttributes) {
            object2 = (DosFileAttributes)basicFileAttributes;
            if (object2.isHidden()) {
                n |= 0x20;
            }
            if (object2.isSystem()) {
                n |= 0x80;
            }
            if (object2.isArchive()) {
                n |= 0x100;
            }
        }
        object2 = null;
        GroupPrincipal groupPrincipal = null;
        if (basicFileAttributes instanceof PosixFileAttributes) {
            object = (PosixFileAttributes)basicFileAttributes;
            Set<PosixFilePermission> set = object.permissions();
            block11: for (PosixFilePermission posixFilePermission : set) {
                int n2 = 0;
                switch (posixFilePermission) {
                    case OWNER_READ: {
                        n2 = 65536;
                        break;
                    }
                    case OWNER_WRITE: {
                        n2 = 131072;
                        break;
                    }
                    case OWNER_EXECUTE: {
                        n2 = 262144;
                        break;
                    }
                    case GROUP_READ: {
                        n2 = 524288;
                        break;
                    }
                    case GROUP_WRITE: {
                        n2 = 0x100000;
                        break;
                    }
                    case GROUP_EXECUTE: {
                        n2 = 0x200000;
                        break;
                    }
                    case OTHERS_READ: {
                        n2 = 0x400000;
                        break;
                    }
                    case OTHERS_WRITE: {
                        n2 = 0x800000;
                        break;
                    }
                    case OTHERS_EXECUTE: {
                        n2 = 0x1000000;
                        break;
                    }
                    default: {
                        LOG.warn("Unused permission " + (Object)((Object)posixFilePermission) + " for " + path);
                        continue block11;
                    }
                }
                n |= n2;
            }
            object2 = object.owner();
            groupPrincipal = object.group();
        }
        object = object2 != null || groupPrincipal != null || l3 != 0L || l4 != 0L ? new FileInfoEx(string, n, l, l2, l4, l3, object2, groupPrincipal) : new FileInfo(string, n, l, l2);
        return object;
    }

    private void setFileInfoJDK6(File file, FileInfo fileInfo, int n) throws NullPointerException, IOException {
        if ((n & 1) != 0) {
            if (!file.setReadable(fileInfo.hasPermission(65536), fileInfo.hasPermission(0x400000))) {
                throw new IOException("Cannot set read permissions " + file);
            }
            if (!file.setWritable(fileInfo.hasPermission(131072), fileInfo.hasPermission(0x800000))) {
                throw new IOException("Cannot set write permissions " + file);
            }
            if (!file.setExecutable(fileInfo.hasPermission(262144), fileInfo.hasPermission(0x1000000))) {
                throw new IOException("Cannot set execute permissions " + file);
            }
        }
        if ((n & 4) != 0 && !file.setLastModified(fileInfo.lastModifiedTime())) {
            throw new IOException("Cannot set last modified time of " + file);
        }
    }

    private final void setFileInfoJDK7(File file, FileInfo fileInfo, int n) throws IOException {
        Object object;
        Path path = file.toPath();
        Class<? extends BasicFileAttributeView> clazz = this.getAttributesView(path);
        BasicFileAttributeView basicFileAttributeView = Files.getFileAttributeView(path, clazz, LinkOption.NOFOLLOW_LINKS);
        FileTime fileTime = null;
        FileTime fileTime2 = null;
        FileTime fileTime3 = null;
        if ((n & 4) != 0) {
            fileTime = FileTime.fromMillis(fileInfo.lastModifiedTime());
        }
        if (fileInfo instanceof FileInfoEx) {
            object = (FileInfoEx)fileInfo;
            if ((n & 8) != 0) {
                fileTime3 = FileTime.fromMillis(((FileInfoEx)object).lastAccessedTime());
            }
            if ((n & 0x10) != 0) {
                fileTime2 = FileTime.fromMillis(((FileInfoEx)object).createdTime());
            }
        }
        if (fileTime != null || fileTime2 != null || fileTime3 != null) {
            basicFileAttributeView.setTimes(fileTime, fileTime3, fileTime2);
        }
        if ((n & 1) != 0) {
            if (!(basicFileAttributeView instanceof PosixFileAttributeView)) {
                throw new IOException("No supported set permissions of " + file);
            }
            object = new HashSet(3);
            int n2 = fileInfo.attributes();
            if ((n2 & 0x10000) != 0) {
                object.add(PosixFilePermission.OWNER_READ);
            }
            if ((n2 & 0x20000) != 0) {
                object.add(PosixFilePermission.OWNER_WRITE);
            }
            if ((n2 & 0x40000) != 0) {
                object.add(PosixFilePermission.OWNER_EXECUTE);
            }
            if ((n2 & 0x80000) != 0) {
                object.add(PosixFilePermission.GROUP_READ);
            }
            if ((n2 & 0x100000) != 0) {
                object.add(PosixFilePermission.GROUP_WRITE);
            }
            if ((n2 & 0x200000) != 0) {
                object.add(PosixFilePermission.GROUP_EXECUTE);
            }
            if ((n2 & 0x400000) != 0) {
                object.add(PosixFilePermission.OTHERS_READ);
            }
            if ((n2 & 0x800000) != 0) {
                object.add(PosixFilePermission.OTHERS_WRITE);
            }
            if ((n2 & 0x1000000) != 0) {
                object.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            ((PosixFileAttributeView)basicFileAttributeView).setPermissions((Set<PosixFilePermission>)object);
        }
        if (fileInfo instanceof FileInfoEx) {
            Object object2;
            if (!(basicFileAttributeView instanceof PosixFileAttributeView)) {
                throw new IOException("No supported set owner/group of " + file);
            }
            object = (FileInfoEx)fileInfo;
            PosixFileAttributeView posixFileAttributeView = (PosixFileAttributeView)basicFileAttributeView;
            if ((n & 0x20) != 0) {
                object2 = ((FileInfoEx)object).getUid();
                if (object2 instanceof UserPrincipal) {
                    posixFileAttributeView.setOwner((UserPrincipal)object2);
                } else {
                    LOG.warn("Cannot set owner of " + path + " because of unknown instance: " + object2);
                }
            }
            if ((n & 0x40) != 0) {
                object2 = ((FileInfoEx)object).getGid();
                if (object2 instanceof GroupPrincipal) {
                    posixFileAttributeView.setGroup((GroupPrincipal)object2);
                } else {
                    LOG.warn("Cannot set group of " + path + " because of unknown instance: " + object2);
                }
            }
        }
    }

    private final Class<? extends BasicFileAttributeView> getAttributesView(Path path) {
        Class clazz;
        try {
            FileStore fileStore = Files.getFileStore(path.getRoot());
            if (fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
                clazz = PosixFileAttributeView.class;
            } else if (fileStore.supportsFileAttributeView(DosFileAttributeView.class)) {
                clazz = DosFileAttributeView.class;
            } else {
                LOG.warn("Unknown OS attributes support");
                clazz = BasicFileAttributeView.class;
            }
        }
        catch (IOException iOException) {
            LOG.warn("Cannot get file store " + path, (Throwable)iOException);
            clazz = BasicFileAttributeView.class;
        }
        return clazz;
    }

    private final Class<? extends BasicFileAttributes> getAttributesType(Path path) {
        Class clazz;
        try {
            FileStore fileStore;
            Path path2 = path.getRoot();
            if (path2 == null) {
                LOG.warn("Cannot get root of path " + path);
                path2 = path;
            }
            if ((fileStore = Files.getFileStore(path2)).supportsFileAttributeView(PosixFileAttributeView.class)) {
                clazz = PosixFileAttributes.class;
            } else if (fileStore.supportsFileAttributeView(DosFileAttributeView.class)) {
                clazz = DosFileAttributes.class;
            } else {
                LOG.warn("Unknown OS attributes support");
                clazz = BasicFileAttributes.class;
            }
        }
        catch (IOException iOException) {
            LOG.warn("Cannot get file store " + path, (Throwable)iOException);
            clazz = BasicFileAttributes.class;
        }
        return clazz;
    }

    private static final long timeToMs(FileTime fileTime) {
        return fileTime != null ? fileTime.toMillis() : 0L;
    }
}

